# -*- coding: utf-8 -*-
'''Calculate cohort push metrics for edadeal pcloud project and publish to statface.'''

import os
import logging

from sandbox import sdk2
import sandbox.common.types.resource as ctr
from sandbox.sdk2.helpers.process import subprocess as sp
from sandbox.projects.Edadeal import Analytics


class EDADEAL_PCLOUD_METRICS_COHORT(sdk2.Resource):
    '''EdadealPCloudMetricsCohort binary to calculate metrics for pcloud project.'''

    any_arch = True
    executable = True
    releasers = ['antonka', 'adsergeev']


class EdadealPCloudMetricsCohort(sdk2.Task):
    '''Calculate EdadealPCloudMetricsCohort metrics.'''
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Parameters):
        kill_timeout = 21600

        start_date = sdk2.parameters.String(
            'Date to start calculations from.',
            default='',
        )
        end_date = sdk2.parameters.String(
            'Date to calculate until.',
            default='',
        )
        statface_token = sdk2.parameters.String(
            'Statface token to publish report.',
            default='',
        )

    def on_execute(self):
        cmd_args = []

        # String parameters
        for key, value in (
            ['--start-date', self.Parameters.start_date],
            ['--end-date', self.Parameters.end_date],
            ['--statface-token', self.Parameters.statface_token],
        ):
            if value:
                cmd_args.extend([key, value])

        os.environ['YT_TOKEN'] = sdk2.Vault.data('ROBOT_EDDL_PCLOUD_TOKEN_YT')
        os.environ['YQL_TOKEN'] = sdk2.Vault.data('ROBOT_EDDL_PCLOUD_TOKEN_YQL')
        os.environ['STATFACE_TOKEN'] = sdk2.Vault.data('ROBOT_EDDL_PCLOUD_TOKEN_STATFACE')
        os.environ['YT_PROXY'] = 'hahn.yt.yandex.net'

        edadeal_pcloud_metrics_cohort_binary = sdk2.Resource.find(
            resource_type=EDADEAL_PCLOUD_METRICS_COHORT,
            state=ctr.State.READY,
        ).first()
        edadeal_pcloud_metrics_cohort_binary_path = str(sdk2.ResourceData(edadeal_pcloud_metrics_cohort_binary).path)

        run_python_udf_binary = sdk2.Resource.find(
            resource_type=Analytics.RUN_PYTHON_UDF,
            state=ctr.State.READY,
        ).first()
        run_python_udf_binary_path = str(sdk2.ResourceData(run_python_udf_binary).path)

        logging.info(
            'Using edadeal_pcloud_metrics_cohort binary created on: ',
            edadeal_pcloud_metrics_cohort_binary.created.strftime('%Y-%m-%d'),
        )
        logging.info(
            'Using run_python_udf binary created on: ',
            run_python_udf_binary.created.strftime('%Y-%m-%d'),
        )
        logging.info(
            '=======\n\n',
            run_python_udf_binary_path,
            edadeal_pcloud_metrics_cohort_binary_path,
            cmd_args,
            '=======\n\n'
        )

        with sdk2.helpers.ProcessLog(self, logger='EdadealPCloudMetricsCohort') as pl:
            sp.check_call(
                [run_python_udf_binary_path, edadeal_pcloud_metrics_cohort_binary_path] + cmd_args,
                stdout=pl.stdout,
                stderr=sp.STDOUT,
            )

        logging.info("Successfully finished process execution")
