# -*- coding: utf-8 -*-
'''Prepare StoriesMetrics tables and push to statFace.'''

import os
import logging

from sandbox import sdk2
import sandbox.common.types.resource as ctr
from sandbox.sdk2.helpers.process import subprocess as sp
from sandbox.projects.Edadeal import Analytics


class STORIES_METRICS_TOOL(sdk2.Resource):
    '''StoriesMetricsTool binary to prepare YT tables.'''

    any_arch = True
    executable = True
    releasers = ['antonka', 'adsergeev']


class StoriesMetrics(sdk2.Task):
    '''Prepare StoriesMetrics tables.'''
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Parameters):
        kill_timeout = 14400

        first_date = sdk2.parameters.String(
            'Log date to start calculations from.',
            default=''
        )
        last_date = sdk2.parameters.String(
            'Log date to calculate until.',
            default=''
        )
        events_table = sdk2.parameters.String(
            'Events table.',
            default=''
        )
        result_folder = sdk2.parameters.String(
            'Result output folder.',
            default=''
        )
        tmp_table = sdk2.parameters.String(
            'Tmp table.',
            default=''
        )

    def on_execute(self):
        cmd_args = []

        # String parameters
        for key, value in (
            ['--first-date', self.Parameters.first_date],
            ['--last-date', self.Parameters.last_date],
            ['--events-table', self.Parameters.events_table],
            ['--result-folder', self.Parameters.result_folder],
            ['--tmp-table', self.Parameters.tmp_table],
        ):
            if value:
                cmd_args.extend([key, value])

        os.environ['YT_TOKEN'] = sdk2.Vault.data('ROBOT_EDDL_ANALYST_YT_TOKEN')
        os.environ['YQL_TOKEN'] = sdk2.Vault.data('ROBOT_EDDL_ANALYST_YQL_TOKEN')
        os.environ['STATFACE_TOKEN'] = sdk2.Vault.data('ROBOT_EDDL_ANALYST_STATFACE_TOKEN')
        os.environ['YT_PROXY'] = 'hahn.yt.yandex.net'

        stories_metrics_binary = sdk2.Resource.find(
            resource_type=STORIES_METRICS_TOOL,
            state=ctr.State.READY,
        ).first()
        stories_metrics_binary_path = str(sdk2.ResourceData(stories_metrics_binary).path)

        run_python_udf_binary = sdk2.Resource.find(
            resource_type=Analytics.RUN_PYTHON_UDF,
            state=ctr.State.READY,
        ).first()
        run_python_udf_binary_path = str(sdk2.ResourceData(run_python_udf_binary).path)

        logging.info(
            'Using StoriesMetricsTool binary created on: ',
            stories_metrics_binary.created.strftime('%Y-%m-%d'),
        )
        logging.info(
            'Using run_python_udf binary created on: ',
            run_python_udf_binary.created.strftime('%Y-%m-%d'),
        )
        logging.info(
            '=======\n\n',
            run_python_udf_binary_path,
            stories_metrics_binary_path,
            cmd_args,
            '=======\n\n'
        )

        with sdk2.helpers.ProcessLog(self, logger='StoriesMetrics') as pl:
            sp.check_call(
                [run_python_udf_binary_path, stories_metrics_binary_path] + cmd_args,
                stdout=pl.stdout,
                stderr=sp.STDOUT,
            )

        logging.info('Successfully finished process execution')
