# -*- coding: utf-8 -*-
"""Prepare UserActivity tables."""

import os
import logging

from sandbox import sdk2
from sandbox.sdk2.helpers.process import subprocess as sp
# from sandbox.projects.Edadeal import Analytics


class USER_ACTIVITY_TOOL(sdk2.Resource):
    """
        UserActivityTool binary to prepare YT tables.
    """
    any_arch = True
    executable = True
    releasers = ['antonka', 'adsergeev']


class UserActivity(sdk2.Task):
    """Prepare UserActivity tables."""
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Parameters):
        kill_timeout = 14400

        first_date = sdk2.parameters.String(
            'Log date to start calculations from.',
            default=''
        )
        last_date = sdk2.parameters.String(
            'Log date to calculate until.',
            default=''
        )
        events_table = sdk2.parameters.String(
            'Events table.',
            default=''
        )
        result_table = sdk2.parameters.String(
            'Result output table.',
            default=''
        )
        run_calc = sdk2.parameters.Bool(
            'Run calculations.',
            default=True
        )

    def on_execute(self):
        cmd_args = []

        # String parameters
        for key, value in (
            ['--first-date', self.Parameters.first_date],
            ['--last-date', self.Parameters.last_date],
            ['--events-table', self.Parameters.events_table],
            ['--result-table', self.Parameters.result_table],
        ):
            if value:
                cmd_args.extend([key, value])

        # Boolean parameters (flags)
        for key, value in (
            ['--run-calc', self.Parameters.run_calc],
        ):
            if value:
                cmd_args.append(key)

        os.environ['YT_TOKEN'] = sdk2.Vault.data('ROBOT_EDDL_ANALYST_YT_TOKEN')
        # os.environ['YQL_TOKEN'] = sdk2.Vault.data('ROBOT_EDDL_ANALYST_YQL_TOKEN')
        os.environ['YT_PROXY'] = 'hahn.yt.yandex.net'

        user_activity_binary_resources = sdk2.Resource.find(
            resource_type=USER_ACTIVITY_TOOL,
            state='READY'
        ).limit(3)
        tool_last_binary = sorted(list(user_activity_binary_resources), key=lambda x: x.created)[-1]
        tool_last_binary_path = str(sdk2.ResourceData(tool_last_binary).path)

        # run_python_udf_binary_resources = sdk2.Resource.find(
        #     resource_type=Analytics.RUN_PYTHON_UDF,
        #     state='READY'
        # ).limit(3)
        # prog_last_binary = sorted(list(run_python_udf_binary_resources), key=lambda x: x.created)[-1]
        # prog_last_binary_path = str(sdk2.ResourceData(prog_last_binary).path)

        logging.info('Using UserActivityTool binary created on: ' + tool_last_binary.created.strftime('%Y-%m-%d'))
        # logging.info('Using run_python_udf binary created on: ' + prog_last_binary.created.strftime('%Y-%m-%d'))
        # logging.info('=======\n\n', prog_last_binary_path, tool_last_binary_path, cmd_args, '=======\n\n')
        logging.info('=======\n\n', tool_last_binary_path, cmd_args, '=======\n\n')

        with sdk2.helpers.ProcessLog(self, logger='UserActivity') as pl:
            # sp.check_call([prog_last_binary_path, tool_last_binary_path] + cmd_args, stdout=pl.stdout, stderr=sp.STDOUT)
            sp.check_call([tool_last_binary_path] + cmd_args, stdout=pl.stdout, stderr=sp.STDOUT)

        logging.info("Successfully finished process execution")
