# coding: utf-8

from sandbox import sdk2
from sandbox.sandboxsdk import environments
from sandbox.common.types import client as ctc
from sandbox.projects.Edadeal.resource_types import YtTableArchive


class BackupYtToSandbox(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        resource_ttl = sdk2.parameters.Integer(
            'Resource ttl', required=True, default=14
        )

        cluster = sdk2.parameters.String(
            'YT cluster', required=True, default='hahn'
        )
        # reactor works with list incorrect
        yt_paths = sdk2.parameters.String('YT table paths', required=True)
        yt_token_vault_name = sdk2.parameters.String(
            'YT token vault name', required=True, default='edadeal-yt-token'
        )

    class Requirements(sdk2.Task.Requirements):
        environments = (environments.PipEnvironment('yandex-yt'),)
        client_tags = ctc.Tag.GENERIC

    description = 'Save tables as sandbox resources'

    def _get_yt_client(self):
        from yt.wrapper import YtClient
        return YtClient(
            self.Parameters.cluster,
            token=sdk2.Vault.data(self.Parameters.yt_token_vault_name)
        )

    def backup_table(self, path):
        import yt.wrapper as yt

        yt_client = self._get_yt_client()

        local_resource_dir, local_resource_name = yt.ypath_split(path)
        local_resource_path = '{}_{}.json_lines'.format(
            yt.ypath_split(local_resource_dir)[1], local_resource_name
        )
        with open(local_resource_path, 'wb') as f:
            for line in yt_client.read_table(
                path, format=yt.JsonFormat(attributes={'encode_utf8': False}),
                raw=True
            ):
                f.write(line)

        resource = YtTableArchive(
            self, '{} archive'.format(local_resource_path), local_resource_path,
            ttl=self.Parameters.resource_ttl
        )
        sdk2.ResourceData(resource).ready()

    def on_execute(self):
        for path in self.Parameters.yt_paths.split():
            self.backup_table(path)
