# -*- coding: utf-8 -*-

from sandbox import sdk2


# TODO
bin_releasers = ['robot-eddl-chercher', 'v-solomatin']
config_releasers = ['robot-eddl-chercher', 'v-solomatin']
data_releasers = ['robot-eddl-chercher', 'v-solomatin']

bin_subscribers = ['v-solomatin']
config_subscribers = ['v-solomatin']
data_subscribers = ['v-solomatin']


class EdadealDjRecommenderServerBin(sdk2.Resource):
    """
    DJ Recommender Server binary for Edadeal
    """

    executable = True
    releasable = True
    releasers = bin_releasers
    release_subscribers = bin_subscribers


class EdadealDjCompiledConfigs(sdk2.Resource):
    """
    DJ compiled configs for Edadeal
    """

    any_arch = True
    releasable = True
    releasers = config_releasers
    release_subscribers = config_subscribers


class EdadealDjShards(sdk2.Resource):
    """
    DJ shards for Edadeal
    """

    any_arch = True
    releasable = True
    releasers = data_releasers
    release_subscribers = data_subscribers
    shard = True


class EdadealDjModels(sdk2.Resource):
    """
    DJ models for Edadeal
    """

    any_arch = True
    releasable = True
    releasers = data_releasers
    release_subscribers = data_subscribers
