#!/usr/bin/env python
"""Pull edadeal geobase to YT."""

import os
# import sys
import json
import logging

from sandbox import sdk2
# from sdk2.helpers.process import subprocess as sp
import sandbox.common.types.misc as ctm
from sandbox.sandboxsdk import environments

RESULTS_PATH = '//home/edadeal/cooked/geoid'


class PullGeobase(sdk2.Task):
    """Pull edadeal geobase to YT."""

    @staticmethod
    def get_pg_data(config):
        import psycopg2
        fields = [
            'id', 'parent_id', 'kind', 'name', 'full_name',
            'geoid', 'area_id', 'path', 'locality_name',
            'locality_name_lower', 'lvl', 'slug', 'tzname', 'utc_offset'
        ]
        query = """
            select
                id,
                parent_id,
                kind, name,
                full_name,
                geoid,
                area_id,
                path,
                locality_name,
                locality_name_lower,
                lvl,
                slug,
                tzname,
                utc_offset
            from geo.geo
        """

        conn = psycopg2.connect(
            **config
        )
        cur = conn.cursor()
        cur.execute(query)
        records = [dict(zip(fields, _)) for _ in cur.fetchall()]
        conn.close()

        return records

    class Requirements(sdk2.Task.Requirements):
        environments = [
            environments.PipEnvironment('yandex-yt', use_wheel=True),
            environments.PipEnvironment('psycopg2'),
        ]
        dns = ctm.DnsType.DNS64

    class Parameters(sdk2.Parameters):
        kill_timeout = 14400

        output_table = sdk2.parameters.String(
            'Output table.',
            default=RESULTS_PATH
        )

    def on_execute(self):
        os.environ['YT_TOKEN'] = sdk2.Vault.data('antonka', 'YT_TOKEN')
        os.environ['YT_PROXY'] = 'hahn.yt.yandex.net'

        import yt.wrapper as yt

        pg_config = json.loads(sdk2.Vault.data('antonka', 'EDADEAL_PG_GEO_CONF'))

        records = self.get_pg_data(pg_config)

        yt.write_table(self.Parameters.output_table, records, format=yt.JsonFormat(attributes={"encode_utf8": False}))

        logging.info("Successfully finished process execution")
