# coding=utf-8
import sandbox.common.types.task as ctt
from sandbox import sdk2

from sandbox.common import errors


def check_task_status_succeed(task_id, raise_not_ok=False):
    task = sdk2.Task[task_id]
    status = task.status
    res = status in ctt.Status.Group.SUCCEED

    if not res and raise_not_ok:
        err_msg = "Task's ({}, type {}) status is not SUCCEED (found {})".format(task_id, task.type, status)
        raise errors.TaskFailure(err_msg)

    return res
