# coding: utf-8
import logging

from sandbox import sdk2
from sandbox.projects.common.nanny import nanny


def get_current_service_sandbox_files(service, nanny_oauth_token):
    nanny_client = nanny.NannyClient(
            api_url='http://nanny.yandex-team.ru/',
            oauth_token=nanny_oauth_token,
        )
    json = nanny_client.get_service_resources(service)
    return json['content']['sandbox_files']


def find_sandbox_file_in_nanny_conf(resource_type, sandbox_files):
    for sandbox_file in sandbox_files:
        if sandbox_file['resource_type'] == resource_type:
            return sandbox_file


def get_resource_id_from_sandbox_file_info(sandbox_file):
    if 'resource_id' in sandbox_file:
        return sandbox_file['resource_id']

    # try to find from task
    task_resource = sdk2.Resource.find(
        task_id=sandbox_file['task_id'],
        type=sandbox_file['task_type'],
    ).first()
    if task_resource:
        return task_resource.id


def get_current_production_resource_id_from_service(service, resource_type, nanny_oauth_token):
    sandbox_file = find_sandbox_file_in_nanny_conf(
        resource_type=resource_type,
        sandbox_files=get_current_service_sandbox_files(service, nanny_oauth_token)
    )
    if not sandbox_file:
        err_msg = 'Error finding resource {} in service {}'.format(resource_type, service)
        logging.error(err_msg)
        raise ValueError(err_msg)

    resource_id = get_resource_id_from_sandbox_file_info(sandbox_file)
    if not resource_id:
        err_msg = 'Error finding resource id from sandbox file:\n{}'.format(sandbox_file)
        logging.error(err_msg)
        raise ValueError(err_msg)
    return resource_id


def get_resource_task_id_from_service(service, resource_type, nanny_oauth_token):
    """ Get resource's task (by type) from service """
    sandbox_file = find_sandbox_file_in_nanny_conf(
        resource_type=resource_type,
        sandbox_files=get_current_service_sandbox_files(service, nanny_oauth_token)
    )
    if not sandbox_file:
        err_msg = 'Error finding resource {} in service {}'.format(resource_type, service)
        logging.error(err_msg)
        raise ValueError(err_msg)

    return sandbox_file['task_id']


def get_resource_id_from_service_sandbox_files(resource_type, sandbox_files):
    sandbox_file = find_sandbox_file_in_nanny_conf(resource_type, sandbox_files)
    if not sandbox_file:
        err_msg = 'Error finding resource {} in sandbox files:\n{}'.format(resource_type, sandbox_files)
        logging.error(err_msg)
        raise ValueError(err_msg)

    resource_id = get_resource_id_from_sandbox_file_info(sandbox_file)
    if not resource_id:
        err_msg = 'Error finding resource id from sandbox file:\n{}'.format(sandbox_file)
        logging.error(err_msg)
        raise ValueError(err_msg)
    return resource_id
