import logging
from datetime import datetime
from time import time

from sandbox import sdk2
import sandbox.common.types.task as ctt

from sandbox.projects.common.nanny import nanny
from sandbox.projects.EntitySearch import resource_types


class EntitySearchDummyResourcePreparation(nanny.ReleaseToNannyTask2, sdk2.Task):
    """ Prepare dummy resource (with id + task's ts) for entitysearch """
    RESOURCE_FILE_NAME = 'es_dummy_resource.txt'

    class Parameters(sdk2.Task.Parameters):
        with sdk2.parameters.RadioGroup('Release type', required=True) as release_type:
            for i, status in enumerate(ctt.ReleaseStatus):
                option_name = str(status)
                setattr(release_type.values, option_name, release_type.Value(status))

    class Requirements(sdk2.Task.Requirements):
        disk_space = 512  # 0.5 Gb
        ram = 512         # 0.5 Gb
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    def make_resource(self, resource_attributes=None):
        resource_attributes = resource_attributes or {}

        ts = time()
        local_ts = datetime.fromtimestamp(ts)
        file_input = 'Task {} timestamps: {:0.6f} ({} local)\n'.format(self.id, ts, local_ts)
        with open(self.RESOURCE_FILE_NAME, 'w') as h:
            h.write(file_input)

        dummy_resource = resource_types.ENTITY_SEARCH_DUMMY_RESOURCE(
            task=self,
            description='Dummy ES resource created at {}'.format(local_ts),
            path=self.RESOURCE_FILE_NAME,
            **resource_attributes
        )

        dummy_resource_data = sdk2.ResourceData(dummy_resource)
        dummy_resource_data.ready()

    def on_execute(self):
        self.make_resource()

    def on_success(self, prev_status):
        logging.info('Release type param: {}'.format(self.Parameters.release_type))
        self.on_release(
            dict(
                releaser=self.author,
                release_status=self.Parameters.release_type,
                release_subject='Releasing dummy ES resource',
                email_notifications={'to': [], 'cc': []},
                release_comments='Releasing dummy ES resource',
            )
        )
