import logging

from sandbox import sdk2
from sandbox.projects.EntitySearch import resource_types
from sandbox.projects.EntitySearch.common.current_production import get_current_production_resource_id_from_service


PRODUCTION_ENTITYSEARCH_NANNY_SERVICE = 'vla-production-entitysearch-yp'


class EntitySearchGetProdDataVersion(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        debug_mode = sdk2.parameters.Bool('hack to skip run on first tag', default=True)
        release_number = sdk2.parameters.Integer('branch number', default=0)
        with sdk2.parameters.Output:
            resource_id = sdk2.parameters.String('Prod ({}) data resource id'.format(PRODUCTION_ENTITYSEARCH_NANNY_SERVICE))
            data_path = sdk2.parameters.String('Prod data yt path')


    def on_execute(self):
        token = sdk2.Vault.data('robot-ontodb', 'nanny-oauth-token')
        data_resource_id = get_current_production_resource_id_from_service(
            PRODUCTION_ENTITYSEARCH_NANNY_SERVICE,
            resource_types.ENTITY_SEARCH_CONVERT_DB_ARCHIVE,
            token
        )

        logging.info('Production data resource id: {}'.format(data_resource_id))
        data_resource = sdk2.Resource[data_resource_id]
        if not data_resource:
            err_msg = "Can't find resource of type {} with id {}".format(
                resource_types.ENTITY_SEARCH_CONVERT_DB_ARCHIVE,
                data_resource_id
            )
            raise errors.TaskFailure(err_msg)
        logging.info("Data version attr in resource is {}".format(data_resource.db_version))
        self.Parameters.resource_id = data_resource_id
        self.Parameters.data_path = "//home/dict/ontodb/ver/daily/{}/all_cards_final.reduced".format(data_resource.db_version)

