# -*- coding: utf-8 -*-

import os
import shutil

from sandbox.projects.common.build.YaMake import BUILD_DIR
from sandbox.projects.EntitySearch import resource_types
from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.projects.EntitySearchBinariesBuild import EntitySearchBinariesBuild


class YaneDataResource(SandboxStringParameter):
    name = "yane_data_resource"
    description = "source YANE_DATA resource id"


class EntitySearchNerDataBuild(EntitySearchBinariesBuild):
    type = "ENTITYSEARCH_NER_DATA_BUILD"

    input_parameters = EntitySearchBinariesBuild.input_parameters + [YaneDataResource]

    def get_resource_attrs(self):
        if self.ctx.get('yane_data_resource'):
            return {'yane_data_resource': self.ctx.get('yane_data_resource')}
        return {}

    @property
    def targets_description(self):
        return [
            ('search/wizard/entitysearch/data/ner/search/wizard/entitysearch/data/ner', 'ner', \
                resource_types.ENTITY_SEARCH_NER_DATA, 'search/wizard/entitysearch/data/ner')
        ]
