import logging

from sandbox import sdk2
from sandbox.common.types import resource as common_resource
from sandbox.projects import resource_types
from sandbox.projects.EntitySearch.common.hitman_helper import HitmanProcessTask

class NerReleaseTask(HitmanProcessTask, sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        hitman_parameters = HitmanProcessTask.Parameters()
        yane_data_resource = sdk2.parameters.Resource(
            'YANE_DATA to release',
            resource_type=resource_types.YANE_DATA,
            state=common_resource.State.READY,
            required=True
        )
        light_ao_formula = sdk2.parameters.String('Light antiobject formula name')
        heavy_ao_formula = sdk2.parameters.String('Heavy antiobject formula name')
        release_type = sdk2.parameters.String(
            'Release type',
            ui=sdk2.parameters.String.UI('select'),
            choices=[('stable', 'stable'), ('prestable', 'prestable'), ('testing', 'testing')],
            default='testing')

    def on_execute(self):
        with self.memoize_stage.start_job:
            job_id = self.start_hitman_process('yourmary',
                {
                    'yane-data-resource-id': self.Parameters.yane_data_resource.id,
                    'light-ao-formula-name': self.Parameters.light_ao_formula,
                    'heavy-ao-formula-name': self.Parameters.heavy_ao_formula,
                    'release-type': self.Parameters.release_type
                }, 'Launch NER release process from task {}#{}'.format(self.type, self.id))
            logging.info("Started Hitman job {}".format(job_id))
            self.Context.job_id = job_id
        if not self.wait_hitman_job_result(self.Context.job_id):
            raise Exception('Hitman task failed or canceled')
        else:
            self.Parameters.yane_data_resource.release = self.Parameters.release_type
            self.Parameters.yane_data_resource.ttl = 'inf'
