from sandbox import sdk2

from sandbox.projects.resource_types import (  # noqa
    ENTITY_SEARCH_CONFIG,   # noqa
    ENTITY_SEARCH_CONVERTER,  # noqa
    ENTITY_SEARCH_DATA,  # noqa
    ENTITY_SEARCH_DBSUBSET_EXECUTABLE,  # noqa
    ENTITY_SEARCH_GAZETEER,  # noqa
    ENTITY_SEARCH_GZT_COMPILER_TOOL,  # noqa
    ENTITY_SEARCH_EXECUTABLE,  # noqa
    ENTITY_SEARCH_TRIE,  # noqa
    EVLOGDUMP_EXECUTABLE,  # noqa
    ONTODB_CARDS_MAIN_DELTA,  # noqa
    ONTODB_CARDS_PATCH,  # noqa
    OTHER_RESOURCE,  # noqa
)  # noqa
from sandbox.projects.resource_types.releasers import entitysearch_releasers


class ENTITY_SEARCH_MAIN_DELTA(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    any_arch = True
    auto_backup = True
    releasers = entitysearch_releasers
    releasable = True


class ENTITY_SEARCH_FLYING_DELTA(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    any_arch = True
    auto_backup = True
    releasers = entitysearch_releasers
    releasable = True


class ENTITY_SEARCH_ACCEPTED_MAIN_DELTA(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    any_arch = True
    auto_backup = True
    releasers = entitysearch_releasers
    releasable = True


class ENTITY_SEARCH_FIX_LIST(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    any_arch = True
    auto_backup = True
    releasers = entitysearch_releasers
    releasable = True


class ENTITY_SEARCH_FAST_STICKY(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    any_arch = True
    auto_backup = True
    releasers = entitysearch_releasers
    releasable = True


class ENTITY_SEARCH_DUMMY_RESOURCE(sdk2.Resource):
    """ Resource for rebooting ES services """
    __default_attribute__ = sdk2.parameters.String

    any_arch = True
    auto_backup = True
    releasers = entitysearch_releasers
    releasable = True


class ENTITY_SEARCH_HOOK_NOTIFIER(sdk2.Resource):
    """Binary with nanny dynamic resource notification logic implemented"""
    __default_attribute__ = sdk2.parameters.String
    any_arch = True
    auto_backup = True
    releasers = entitysearch_releasers
    releasable = True


class ENTITY_SEARCH_FRESH(sdk2.Resource):
    """ Entitysearch fresh data """
    __default_attribute__ = sdk2.parameters.String

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = entitysearch_releasers


class ENTITY_SEARCH_NER_DATA(sdk2.Resource):
    """ Entitysearch ner data """
    __default_attribute__ = sdk2.parameters.String

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = entitysearch_releasers


class ENTITY_SEARCH_NER_TEST_DATA(sdk2.Resource):
    """ Entitysearch test ner data """
    __default_attribute__ = sdk2.parameters.String

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = entitysearch_releasers


class ENTITY_SEARCH_CONVERT_DB_ARCHIVE(sdk2.Resource):
    """ Entitysearch convert db single archive output """
    __default_attribute__ = sdk2.parameters.String

    any_arch = True
    auto_backup = True
    releasable = True
    releasers = entitysearch_releasers


class ENTITY_SEARCH_REALTIME_DEPLOY_CONFIG(sdk2.Resource):
    """ Config with ENTITY_SEARCH_REALTIME resource id and deploy to producion rules [OBJECTS-13190] """
    __default_attribute__ = sdk2.parameters.String
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = entitysearch_releasers


class ENTITY_SEARCH_APP_HOST_SHOOTER_PLAN(sdk2.resource.AbstractResource):
    """
        Plan for apphost/tools/grpc_client
    """
    auto_backup = True
