import logging

from sandbox import sdk2
from sandbox.projects.EntitySearch.release_machine_helpers import BetaAcceptingTask, StarTrekReportingTask
from sandbox.projects.EntitySearch.common.hitman_helper import HitmanProcessTask


class RunChimeraTask(BetaAcceptingTask, StarTrekReportingTask, HitmanProcessTask, sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        beta = sdk2.parameters.String('beta with new binaries', required=True)
        beta_as_prod = sdk2.parameters.String('production copy')
        hitman_parameters = HitmanProcessTask.Parameters()
        star_trek_parameters = StarTrekReportingTask.Parameters()
        beta_parameters = BetaAcceptingTask.Parameters()

    @property
    def properties(self):
        data = {'beta1_newbinaries_old_data': self.Parameters.beta}
        if self.Parameters.release_number:
            data['rm_issue'] = self._get_star_trek_issue(self.Parameters.release_number)
        if self.Parameters.beta_as_prod:
            data['production'] = self.Parameters.beta_as_prod
        return data

    def on_execute(self):
        self.ensure_stable_betas()
        self.start_chimera()

    def ensure_stable_betas(self):
        wait_betas = [self.Parameters.beta]
        if self.Parameters.beta_as_prod:
            wait_betas.append(self.Parameters.beta_as_prod)
        for beta in wait_betas:
            beta_name = beta.split('.')[0]
            logging.info("Start waiting beta %s", beta_name)
            self.check_yappy_beta_status(beta_name)

    def start_chimera(self):
        self.start_hitman_process('robot-ontodb', self.properties, 'Launch Chimera from SB, branch {}'.format(str(self.Parameters.release_number)))
