# -*- coding: utf-8 -*-

import os
import shutil

from sandbox.projects import resource_types
from sandbox.projects.common.build import parameters
from sandbox.projects.EntitySearch import resource_types as es_resource_types
from sandbox.projects.common.build.YaMake import YaMakeTask, BUILD_DIR
from sandbox.projects.common.nanny import nanny


DISK_SPACE_FOR_BINARIES = 70 * 1024  # 70 GB


# Я не знаю как это переопределить лучше к сожалению.
class UseArcadiaApiFuseTrue(parameters.UseArcadiaApiFuse):
    default_value = True


class EntitySearchBinariesBuild(YaMakeTask, nanny.ReleaseToNannyTask):
    type = 'ENTITYSEARCH_BINARIES_BUILD'

    execution_space = DISK_SPACE_FOR_BINARIES

    input_parameters = [
        param for param in YaMakeTask.input_parameters
        if param.name not in [
            'targets',
            UseArcadiaApiFuseTrue.name,
        ]
    ] + [UseArcadiaApiFuseTrue]

    """
        Описание целей сборки
        0. Где лежит после сборки
        1. Имя файла (папки) в экспортируемом ресурсе
        2. Тип экспортируемого ресурса
        3. Цель сборки
    """
    @property
    def targets_description(self):
        return [
            (
                'search/tools/evlogdump/evlogdump', 'evlogdump',
                resource_types.EVLOGDUMP_EXECUTABLE, 'search/tools/evlogdump'
            ),
            (
                'web/daemons/entitysearch/entitysearch', 'entitysearch',
                resource_types.ENTITY_SEARCH_EXECUTABLE, 'web/daemons/entitysearch'
            ),
            (
                'search/wizard/entitysearch/tools/convertor/convertor', 'convertor',
                resource_types.ENTITY_SEARCH_CONVERTER, 'search/wizard/entitysearch/tools/convertor'
            ),
            (
                'search/wizard/entitysearch/tools/dbsubset/dbsubset', 'dbsubset',
                resource_types.ENTITY_SEARCH_DBSUBSET_EXECUTABLE, 'search/wizard/entitysearch/tools/dbsubset'
            ),
            (
                'search/wizard/entitysearch/tools/daemon_checker/daemon_checker', 'daemon_checker',
                resource_types.ENTITY_SEARCH_DAEMON_CHECKER_TOOL, 'search/wizard/entitysearch/tools/daemon_checker'
            ),
            (
                'search/wizard/entitysearch/tools/esgztcompiler/esgztcompiler', 'esgztcompiler',
                resource_types.ENTITY_SEARCH_GZT_COMPILER_TOOL, 'search/wizard/entitysearch/tools/esgztcompiler'
            ),
            (
                'search/wizard/entitysearch/tools/es_hook_notifier/bin/es_hook_notifier', 'es_hook_notifier',
                es_resource_types.ENTITY_SEARCH_HOOK_NOTIFIER, "search/wizard/entitysearch/tools/es_hook_notifier"
            ),
        ]

    def get_resource_attrs(self):
        return {}

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        YaMakeTask.on_release(self, additional_parameters)

    def export_build_resources(self):
        src_path = BUILD_DIR

        for res in self.targets_description:
            res_path, filename, res_type, _ = res
            to_path = self.abs_path(filename)
            from_path = os.path.join(src_path, res_path)
            if os.path.isdir(from_path):
                shutil.copytree(from_path, to_path)
            else:
                shutil.copy(from_path, to_path)
            self.create_resource(filename, to_path, res_type, attributes=self.get_resource_attrs())

    def do_execute(self):
        YaMakeTask.do_execute(self)
        self.export_build_resources()

    def get_targets(self):
        return [res[3] for res in self.targets_description]


__Task__ = EntitySearchBinariesBuild
