# -*- coding: utf-8 -*-

from sandbox.common.types import client as ctc
from sandbox.projects import resource_types
from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.projects.EntitySearchBinariesBuild import EntitySearchBinariesBuild


DISK_SPACE_FOR_DATA = 400 * 1024  # 400 GB
REQUIRED_RAM = 128 * 1024         # 128 Gb


class DbVersion(SandboxStringParameter):
    name = 'db_version'
    description = 'Db version'


class EntitySearchDataBuild(EntitySearchBinariesBuild):
    type = 'ENTITYSEARCH_DATA_BUILD'

    execution_space = DISK_SPACE_FOR_DATA
    required_ram = REQUIRED_RAM
    input_parameters = EntitySearchBinariesBuild.input_parameters + [DbVersion]

    def get_resource_attrs(self):
        if self.ctx.get('db_version'):
            return {'db_version': self.ctx.get('db_version')}
        return {}

    @property
    def targets_description(self):
        return [
            ('search/wizard/entitysearch/data/shard/search/wizard/entitysearch/data/shard_data', 'entitysearch_shard',\
                resource_types.ENTITY_SEARCH_DATA, 'search/wizard/entitysearch/data/shard')
        ]

    @property
    def release_template(self):
        subj = 'Releasing ' + self.descr
        return self.ReleaseTemplate(
            cc=['entity-search-releases'],
            subject=subj,
            message=subj,
        )


__Task__ = EntitySearchDataBuild
