# -*- coding: utf-8 -*-

import urllib
import urlparse


REARR = ('rearr', 'entsearch_experiment')
WIZEXTRA = ('wizextra', 'experiment')


def _remove_experiment_flag_from_cgi_subparam(subparam, experiment_key):
    kv = subparam.split('=', 1)
    if len(kv) != 2:
        return subparam
    if kv[0] == experiment_key:
        return
    return urllib.quote(subparam)


def _remove_experiment_flag_from_cgi_param(cgi_param):
    kv = cgi_param.split('=', 1)
    if len(kv) != 2:
        return cgi_param
    k = kv[0]
    if k not in (REARR[0], WIZEXTRA[0]):
        return cgi_param
    v = urllib.unquote(kv[1])
    subparams = v.split(';')

    processed_subparams = []
    experiment_key = REARR[1] if k == REARR[0] else WIZEXTRA[1]
    for s in subparams:
        processed = _remove_experiment_flag_from_cgi_subparam(s, experiment_key)
        if processed:
            processed_subparams.append(processed)
    new_v = ';'.join(processed_subparams)
    if new_v:
        return '{}={}'.format(k, new_v)


def remove_experiment_flags(request):
    if request.find('experiment') == -1:
        return request

    parse_result = urlparse.urlparse(request)
    query = parse_result.query
    cgi_params = query.split('&')
    processed_cgi_params = []
    for p in cgi_params:
        new_p = _remove_experiment_flag_from_cgi_param(p)
        if new_p:
            processed_cgi_params.append(new_p)
    url = urlparse.ParseResult(parse_result.scheme,
                               parse_result.netloc,
                               parse_result.path,
                               parse_result.params,
                               '&'.join(processed_cgi_params),
                               parse_result.fragment).geturl()
    return url
