# -*- coding: utf-8 -*-

import pytest

from sandbox.projects.EntitySearchLogs.lib.filter import remove_experiment_flags


@pytest.mark.parametrize('req,result', [
    ('/search?rearr=entsearch_experiment=s', '/search'),
    ('/search?wizextra=a=c;experiment=a', '/search?wizextra=a%3Dc'),
    ('/search?a=b&rearr=scheme%3D1%3Bentsearch_experiment%3Dtrololo', '/search?a=b&rearr=scheme%3D1'),
    ('/search?wizextra=scheme%3D1%3Bexperiment%3Dtrololo', '/search?wizextra=scheme%3D1'),
    ('/search?a=b&rearr=entsearch_experiment%3Dtrololo%3Bscheme%3D1', '/search?a=b&rearr=scheme%3D1'),
    ('/search?wizextra=%3Bexperiment%3Dtrololo%3Bscheme%3D1', '/search?wizextra=scheme%3D1'),
    ('req/path/?a=b&wizextra=experiment=c&d=e', 'req/path/?a=b&d=e'),
    ('req/path/?a=b&wizextra=experiment=c&rearr=entsearch_experiment=z&wizextra=experiment=c&d=e', 'req/path/?a=b&d=e'),
])
def test_removes_experiment_flags(req, result):
    assert remove_experiment_flags(req) == result


@pytest.mark.parametrize('req', [
    '',
    '/get?obj=ruw1234773%2Cruw99765&lang=ru&tld=ru&client=news-report',
    '/search?wizextra=trololo',
    '/search?text=1&wizextra=tratata',
    '/search?rearr=d&text=trololo&rearr=scheme_blender/antiwizard/influenced/video%3D1;has_flash%3D0',
    '/path?rearr=rearr&rearr=trololo',
    '/search?rearr=experiment%3Da',
    '/search?wizextra=entsearch_experiment%3Da',
    '/search?text=1&rearr=experiment%3Da',
    '/search?text=1&wizextra=entsearch_experiment%3Da',
    '/search?rearr=a%3Db;experiment%3Da&text=2',
    '/search?wizextra=entsearch_experiment%3Da&text=2',
    '/search?a=b&wizexra%3Dexperiment=c&d=e',
    'a=b',
])
def test_does_not_change(req):
    assert remove_experiment_flags(req) == req
