# -*- coding: utf-8 -*-

import io
import os
import json
import logging

from sandbox.sandboxsdk.parameters import SandboxBoolParameter, ResourceSelector, SandboxIntegerParameter
from sandbox.sandboxsdk.task import SandboxTask

from sandbox.projects import resource_types

FOLDER_PATH = 'apphost_requests'


class Requests(ResourceSelector):
    name = 'requests'
    description = "Query list textfile (plain text, empty to autodetect)"
    resource_type = resource_types.PLAIN_TEXT_QUERIES
    attrs = {'entitysearch_test_requests_for_client': 'nmeta'}


class OnlyEnto(SandboxBoolParameter):
    name = 'only_ento'
    description = 'Select only requests with ento param'
    default_value = True


class RequestsLimit(SandboxIntegerParameter):
    name = 'requests_limit'
    description = 'Requests limit'
    default_value = 1000


class EntitySearchNMetaToAppHost(SandboxTask):
    """
        Таск для конвертации http-запросов в аппхостовые для тестирования бекенда
    """

    type = 'ENTITYSEARCH_NMETA_REQS_TO_APPHOST_REQS'

    input_parameters = (Requests, RequestsLimit, OnlyEnto)

    def on_execute(self):
        import lib.req_converter

        requests_path = self.sync_resource(self.ctx[Requests.name])
        os.mkdir(FOLDER_PATH)
        self.create_resource(FOLDER_PATH, FOLDER_PATH, resource_types.ENTITY_SEARCH_APPHOST_REQUESTS)
        contexts_cnt = 0
        contexts_limit = self.ctx[RequestsLimit.name]
        with io.open(requests_path, 'r', encoding='utf8') as requests_file:
            for request in requests_file:
                if not request or self.ctx[OnlyEnto.name] and request.find('&ento=') == -1:
                    continue

                apphost_context = lib.req_converter.convert_request_url_to_apphost_context(request)
                if apphost_context:
                    context_file_name = 'apphost_requests/context_{:06d}.json'.format(contexts_cnt)
                    contexts_cnt += 1
                    with open(context_file_name, 'w') as context_file:
                        serialized = unicode(json.dumps(apphost_context).decode('unicode-escape').encode('utf8'), encoding='utf8') + u'\n'
                        logging.info(serialized)
                        # context_file.write(serialized)
                        context_file.write(json.dumps(apphost_context))
                    if contexts_cnt >= contexts_limit:
                        break


__Task__ = EntitySearchNMetaToAppHost
