# -*- coding: utf-8 -*-

import urlparse


def _parse_subparams(param):
    sub_params = {}
    for sub_param in param.split(';'):
        eq = sub_param.find('=')
        if eq != -1:
            key = sub_param[:eq]
            value = sub_param[eq + 1:]
            values = sub_params.get(key)
            if not values:
                sub_params[key] = [value]
            else:
                values.append(value)
    return sub_params


def _copy_if_has(dst, src, keys):
    for key in keys:
        if key in src:
            dst[key] = src[key]


def convert_request_url_to_apphost_context(url):
    parsed = urlparse.urlparse(url)
    if not parsed:
        return

    cgi_params = urlparse.parse_qs(parsed.query.replace(';', '%3B'))
    if not cgi_params:
        return

    results = []
    request = {
        'type': 'request',
        'uri': url,
        'params': {}
    }
    device = {}
    internal_params = {}

    tld = cgi_params['tld']
    if tld:
        request['tld'] = tld[0]

    rearr = cgi_params.get('rearr')
    if rearr:
        sub_params = _parse_subparams(rearr[0])
        is_mobile = sub_params.get('is_mobile')
        if is_mobile:
            device['type'] = 'device'
            device['is_mobile'] = 1 if is_mobile[0] == '1' else 0

        internal_params['all'] = {
            'CONTEXT': {
                'MAIN': {
                    'source': {
                        'WEB_ALL': {
                            'rearr': rearr
                        }
                    }
                }
            }
        }
        internal_params['type'] = 'flags'

    params = request['params']
    _copy_if_has(params, cgi_params, ('lr', 'text', 'user_request', 'ento', 'qtree'))

    results.append(request)
    if device:
        results.append(device)
    if internal_params:
        results.append(internal_params)

    ret = [
        {
            'results': results,
            'name': 'INIT'
        }
    ]
    return ret
