# -*- coding: utf-8 -*-

import os
import time

from sandbox.sandboxsdk.environments import SvnEnvironment
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.paths import make_folder
from sandbox.sandboxsdk.svn import Arcadia

from sandbox.projects import resource_types
from sandbox.projects.common.nanny import nanny
from sandbox.projects.common.wizard.utils import tar


class EntitySearchRealtimeGeneration(nanny.ReleaseToNannyTask, SandboxTask):
    type = 'ENTITYSEARCH_REALTIME_GENERATION'

    environment = (SvnEnvironment(), )

    def initCtx(self):
        self.ctx['fail_on_any_error'] = True

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        SandboxTask.on_release(self, additional_parameters)

    def on_execute(self):
        rt_dirname = 'realtime'
        make_folder(rt_dirname)

        rt_fixlist_remote = 'svn+ssh://arcadia.yandex.ru/robots/trunk/wizard-data/entity_search/fresh/fixlist.txt'
        rt_fixlist_local = os.path.join(rt_dirname, 'fixlist.txt')
        revision = Arcadia.info(rt_fixlist_remote)['commit_revision']
        Arcadia.export(rt_fixlist_remote, rt_fixlist_local, revision=revision)

        with file(os.path.join(rt_dirname, "version.info"), "wb") as versionFile:
            version_tpl = '{"SvnRevision":"%s","SandboxTask":"%s","GenerationTime":"%s","Revision":%s,"Task":%s}\n'
            versionFile.write(version_tpl % (revision, self.id, time.strftime("%d.%m.%Y %H:%M"), revision, self.id))

        resource = self.create_resource('entitysearch realtime', tar(rt_dirname), resource_types.ENTITY_SEARCH_REALTIME)
        self.mark_resource_ready(resource)


__Task__ = EntitySearchRealtimeGeneration
