# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.task import SandboxTask

from sandbox.projects.EntitySearchRealtimeGeneration import EntitySearchRealtimeGeneration


class EntitySearchRealtimeRelease(SandboxTask):
    type = 'ENTITYSEARCH_REALTIME_RELEASE'

    def initCtx(self):
        self.ctx['fail_on_any_error'] = True

    def on_execute(self):
        if 'release_task' not in self.ctx:
            self.ctx['release_task'] = self.create_subtask(
                task_type=EntitySearchRealtimeGeneration.type,
                description='making new realtime release',
                input_parameters={},
            ).id
            self.wait_task_completed(self.ctx['release_task'])

        self.create_release(
            task_id=self.ctx['release_task'],
            subject='realtime release',
            addresses_to=['entity-search-releases@yandex-team.ru']
        )


__Task__ = EntitySearchRealtimeRelease
