#! /usr/bin/env python
# -*- coding: utf-8 -*-

import urllib
import json
import sys


def has_assoc(card):
    if not ("related_object" in card):
        return False
    comp = lambda obj: "type" in obj and obj["type"] == "assoc"
    return any(comp(obj) for obj in card["related_object"])


def quality_cards_count(mask, fl):
    total_cards = 0
    good_cards = 0
    with open(fl, 'r') as input_file:
        for line in input_file.readlines():
            total_cards += 1
            url = mask.format(line.strip().lstrip('#'))
            if url:
                res = urllib.urlopen(url)
                cur_json = json.loads(res.read())
                if "cards" in cur_json:
                    card = cur_json["cards"][0]
                    if "base_info" in card and "wiki_snippet" in card and has_assoc(card):
                        good_cards += 1
    return (good_cards, total_cards)


def main():
    """
    Main function for cheking quality after starting daemon in production
    """
    if len(sys.argv) < 4:
        print 'Wrong arguments'
        print 'Usage: {} HOST:PORT THRESHOLD IDS_FILE'.format(sys.argv[0])
        return 2

    host_port, threshold, filename = sys.argv[1], int(sys.argv[2]), sys.argv[3]
    if threshold == 0:
        'Threshold should not be 0'
        return 2

    good_cards, total_cards = quality_cards_count('http://{}/get?obj={{}}'.format(host_port), filename)
    good_cards_percentage = good_cards * 100 / total_cards
    if good_cards_percentage < threshold:
        print 'Quality checker failed: there are too few good cards (good: {}, total: {}, percentage: {}, threshold: {})'.format(good_cards, total_cards, good_cards_percentage, threshold)
        return 1
    return 0


if __name__ == '__main__':
    exit(main())
