# -*- coding: utf-8 -*-

import os


MAX_NODES_COUNT = 200000  # USEREXP-14551
MAX_FILE_SIZE = 3 * 1024 * 1024 * 1024  # 3Mb


class Node:
    def __init__(self, line):
        self.line = line

        p = [x.strip() for x in line.split("\t")]
        self.letter = p[0]
        self.info = []

        i = 1

        while i < len(p):
            num = int(p[i])
            pack = p[(i + 1): (i + 1 + num)]
            self.info.append(pack)
            i += num + 1

    def get_children(self):
        if self.letter in ['E', 'L', 'F']:
            return set()

        children = self.info[0 if self.letter == 'S' else 1]
        children_set = set(int(x) for x in children if not x == '')

        return children_set


def parse_config(config):
    lines = config.split("\n")

    version = int(lines[1])

    num_params = int(lines[0])
    num_nodes = int(lines[num_params + 1])

    nodes_str = lines[(num_params + 2): (num_params + 2 + num_nodes)]
    nodes = [Node(x) for x in nodes_str]

    return version, nodes


def extract_nodes_regions(nodes):
    regions = set()
    for node in nodes:
        if node.letter == 'r':
            region = int(node.info[0][0])
            regions.add(region)

    regions = sorted(regions)
    return regions


def validate_nodes(nodes):
    assert len(nodes) <= MAX_NODES_COUNT, "Nodes in config {} ({} allowed)".format(len(nodes), MAX_NODES_COUNT)

    for index in range(len(nodes)):
        node = nodes[index]
        for child in node.get_children():
            assert child > index


def validate_config_file(path):
    assert os.path.getsize(path) <= MAX_FILE_SIZE

    with open(path, 'r') as f:
        version, nodes = parse_config(f.read())

    validate_nodes(nodes)


if __name__ == "__main__":
    import sys
    validate_config_file(sys.argv[1])
