# -*- coding: utf-8 -*-
"""
    Task used to create resources with gencfg group owners and group hosts in order to export to cauth.
"""

import os

# stuff from sandbox
from sandbox.projects import resource_types
from sandbox.sandboxsdk.process import run_process

# auxiliarily gencfg stuff
from sandbox.projects.common.gencfg import utils as config_generator_utils
from sandbox.projects.common.gencfg.task import IGencfgBuildTask
from sandbox.projects.common.utils import get_bsconfig


class ExportGencfgToCauth(IGencfgBuildTask):
    type = 'EXPORT_GENCFG_TO_CAUTH'
    cores = 1
    required_ram = 10 * 1024
    execution_space = 20 * 1024

    def get_cauth_hosts_file(self):
        return self.abs_path('group.hosts')

    def get_cauth_owners_file(self):
        return self.abs_path('group.owners')

    def on_enqueue(self):
        host_resource = self._create_resource(
            self.descr, self.get_cauth_hosts_file(),
            resource_types.GENCFG_CAUTH_EXPORT_HOSTS, arch='any'
        )
        owner_resource = self._create_resource(
            self.descr, self.get_cauth_owners_file(),
            resource_types.GENCFG_CAUTH_EXPORT_OWNERS, arch='any'
        )

    def on_execute(self):
        self.mark_released_resources("stable")

        config_generator_utils.clone_gencfg_all(self.get_src_path(), 'full')
        run_process(["bash", "./install.sh", "tests"], work_dir=self.get_src_path(), log_prefix="install")

        run_process(["/skynet/python/bin/python", "./utils/common/precalc_caches.py"], work_dir=self.get_src_path(), log_prefix="precal_caches")

        custom_env = os.environ.copy()
        custom_env['GENCFG_DEFAULT_OAUTH'] = self.get_vault_data('GENCFG', 'gencfg_default_oauth')
        run_process(["/skynet/python/bin/python", "./utils/common/export_cauth.py", "-a", "export", "--hosts-name", self.get_cauth_hosts_file(),
                     "--owners-name", self.get_cauth_owners_file(), "--bsconfig", get_bsconfig()],
                     environment=custom_env, work_dir=self.get_src_path(), log_prefix="export_cauth")


__Task__ = ExportGencfgToCauth
