from sandbox.projects.common.build import parameters
from sandbox.sandboxsdk.parameters import SandboxStringParameter, SandboxBoolParameter
import sandbox.sandboxsdk.svn as sdk_svn
import sandbox.sandboxsdk.errors as sdk_errors

from sandbox.projects.common.build import YaPackage

ARCADIA_PREFIX = 'arcadia/'

WARNING_MESSAGE = '\
Task BUILD_ROBOT_PACKAGES is deprecated \
and works using FAKE_BUILD_ROBOT_PACKAGES adapter. \
Please use YA_PACKAGE instead.'


class PackagesInputParameter(SandboxStringParameter):
    name = 'sandbox_task_packages'
    description = "Packages path, related to root ';'-separated"
    required = True


class UploadRepParameter(SandboxStringParameter):
    name = 'upload_rep'
    description = 'Upload to'
    required = False
    default_value = ''
    choices = [
        ("do not upload", ""),
        ("search", "search"),
        ("search-test", "search-test"),
        ("search-precise", "search-precise"),
        ("yandex-precise", "yandex-precise"),
        ("search-lucid", "search-lucid"),
        ("yandex-lucid", "yandex-lucid"),
        ("search-trusty", "search-trusty"),
        ("yandex-trusty", "yandex-trusty"),
        ("yabs-precise", "yabs-precise"),
        ("yabs-trusty", "yabs-trusty")
    ]


class ChangeLogParameter(SandboxStringParameter):
    name = 'change_log'
    description = 'Change log text'
    required = False
    default_value = ''


class StripDebugInformationParameter(SandboxBoolParameter):
    name = "strip_debug_information"
    description = 'Strip debug information'
    required = False
    default_value = False


class KeyUserParameter(SandboxStringParameter):
    name = "key_user_name"
    description = 'Name of the user to sign the package'
    required = False  # required = True Temporarily changed because of the bug in sandbox
    choices = [
        ("robot-simcity", "robot-simcity"),
        ("robot-admins", "robot-admins"),
        ("zomb-prj-216", "zomb-prj-216"),
        ("robot-geosearch", "robot-geosearch"),
        ("yabs-commiter", "yabs-commiter"),
        ("mekagem", "mekagem")
    ]
    default_value = None


class BuildProfileParameter(SandboxStringParameter):
    name = "build_profile"
    description = 'Build Profile'
    required = True
    default_value = "release"
    choices = [("release", "release"), ("debug", "debug")]


class ResourceTypeParameter(SandboxStringParameter):
    name = "resource_type"
    description = 'Created package resource type or types separated by ;'
    required = True
    default_value = "TEAMCITY_RESOURCE"


class UseYaDevParameter(SandboxBoolParameter):
    name = "use_ya_dev"
    description = 'Use ya-dev to build'
    required = False
    default_value = False


class PackageFormatParameter(SandboxStringParameter):
    name = "package_format"
    description = '[Beta] Package format'
    required = True
    default_value = "debian"
    choices = [("debian", "debian"), ("tar", "tar")]


class FasterDebuildParameter(SandboxBoolParameter):
    name = "fast_debuild"
    description = 'Faster (but un-uploadable) build of debian packages'
    required = False
    default_value = False


class SignUploadPackageParameter(SandboxBoolParameter):
    name = "sign_upload_package"
    description = 'Sign and/or upload package'
    required = True
    default_value = True
    sub_fields = {
        'true': [
            UploadRepParameter.name,
            KeyUserParameter.name
        ],
        'false': [
            FasterDebuildParameter.name
        ]
    }


class FakeBuildRobotPackages(YaPackage.YaPackage, object):
    """
        Adapter from BUILD_ROBOT_PACKAGES to YA_PACKAGE.
    """

    type = 'FAKE_BUILD_ROBOT_PACKAGES'

    input_parameters = (
        parameters.ArcadiaUrl,
        PackagesInputParameter,
        ChangeLogParameter,
        StripDebugInformationParameter,
        BuildProfileParameter,
        SignUploadPackageParameter,
        KeyUserParameter,
        UploadRepParameter,
        FasterDebuildParameter,
        ResourceTypeParameter,
        PackageFormatParameter,
        UseYaDevParameter,
    )

    def on_enqueue(self):
        packages = self.ctx.get(PackagesInputParameter.name).split(';')
        packages = [(p[len(ARCADIA_PREFIX):] if p.startswith(ARCADIA_PREFIX) else p) for p in packages]
        self.ctx[YaPackage.PackagesParameter.name] = ';'.join(packages)

        self.ctx[YaPackage.ResourceTypeParameter.name] = self.ctx.get(ResourceTypeParameter.name)

        self.ctx[YaPackage.PackageTypeParameter.name] = self.ctx.get(PackageFormatParameter.name)
        self.ctx[YaPackage.BuildTypeParameter.name] = self.ctx.get(BuildProfileParameter.name)
        self.ctx[YaPackage.StripBinariesParameter.name] = self.ctx.get(StripDebugInformationParameter.name)

        self.ctx[YaPackage.RunLongTestsParameter.name] = False
        self.ctx[YaPackage.IgnoreFailTestsParameter.name] = False
        self.ctx[YaPackage.RunTestsParameter.name] = False

        self.ctx[YaPackage.ChangelogParameter.name] = self.ctx.get(ChangeLogParameter.name)
        self.ctx[YaPackage.KeyUserParameter.name] = self.ctx.get(KeyUserParameter.name)
        self.ctx[YaPackage.PublishToParameter.name] = self.ctx.get(UploadRepParameter.name)
        self.ctx[YaPackage.SloppyDebianParameter.name] = self.ctx.get(FasterDebuildParameter.name)
        self.ctx[YaPackage.PublishPackageParameter.name] = self.ctx.get(SignUploadPackageParameter.name)

        self.ctx[YaPackage.UseYaDevParameter.name] = self.ctx.get(UseYaDevParameter.name)
        self.ctx[YaPackage.UseNewFormatParameter.name] = False

        super(FakeBuildRobotPackages, self).on_enqueue()

    def _check_if_fresh(self):
        arcadia_url = self.ctx.get(parameters.ArcadiaUrl.name)
        parsed_url = sdk_svn.Arcadia.parse_url(arcadia_url)
        branch, tag = parsed_url[2], parsed_url[3]

        arcadia_src_dir = self.get_arcadia_src_dir()
        revision = sdk_svn.Arcadia.info(arcadia_src_dir)['entry_revision']

        if (branch or tag or 'trunk') == 'trunk' and int(revision) > 2005328:
            raise sdk_errors.SandboxTaskFailureError(
                'Please use new task YA_PACKAGE instead of BUILD_ROBOT_PACKAGES. '
                'See task FAKE_BUILD_ROBOT_PACKAGES for details.'
            )

    def on_execute(self):
        self.set_info(WARNING_MESSAGE, do_escape=False)

        # Force users to migrate to YA_PACKAGE
        self._check_if_fresh()

        super(FakeBuildRobotPackages, self).on_execute()


__Task__ = FakeBuildRobotPackages
