# coding: utf-8

import datetime
import json
import logging
import requests
from sandbox.sandboxsdk.channel import channel
import sandbox.sandboxsdk.task as sdk_task


class Task(sdk_task.SandboxTask):
    """The process of forming a weekly report"""
    type = "FORMING_WEEKLY_REPORT"

    def on_execute(self):
        current_date = datetime.datetime.now()
        date_week_ago = current_date - datetime.timedelta(days=7)
        week_number = current_date.isocalendar()[1]
        time = '{:02d}:{:02d}:{:02d}'.format(
            current_date.hour,
            current_date.minute,
            current_date.second
        )
        year = current_date.year
        persons = ('keepclean', 'moridin')

        query_filter = {
            'query': 'Assignee: {0} AND Resolved: "{1} {3}".."{2} {3}"'.format(
                ', '.join(persons),
                date_week_ago.date(),
                current_date.date(),
                time
            )
        }

        st_url = 'http://st-api.yandex-team.ru/v2/issues/_search?perPage=100&language=en'
        oauth_token = self.get_vault_data('CPLB', 'robot-balancer-token')
        session = requests.Session()
        session.headers['Authorization'] = 'OAuth {}'.format(oauth_token)
        session.headers['Content-Type'] = 'application/json'

        current_tickets = session.post(
            st_url, data=json.dumps(query_filter)
        ).json()

        mail_to = 'alonger@yandex-team.ru'
        mail_cc = 'rccs-weekly-report@yandex-team.ru'
        mail_subject = 'Week {0} {1}: {2}'.format(week_number, year, ' + '.join(persons))
        mail_body = 'week {}\n\n'.format(week_number)
        for item in current_tickets:
            mail_body += '* {} {}\n'.format(
                item['key'].encode('utf-8'),
                item['summary'].encode('utf-8')
            )
        logging.info('\nmail_to: {}\nmail_cc: {}\nmail_subject: {}\n\nmail_body: {}\n'.format(
            mail_to, mail_cc, mail_subject, mail_body
        ))
        channel.sandbox.send_email(
            mail_to,
            mail_cc,
            mail_subject,
            mail_body,
            content_type='text/plain',
            charset='utf-8'
        )


__Task__ = Task
