# coding=utf-8
import os

from sandbox import sdk2
from sandbox.projects.resource_types import TYCOON_AUX_ADVERTS_SOURCE
from sandbox.sandboxsdk import process
from sandbox.sandboxsdk.environments import PipEnvironment

REQUIRED_PACKAGES = [
    ('yandex-yt', '0.7.34-0'),
    ('yandex-yt-yson-bindings-skynet', None),
    ('vkbeautify', None)
]
EXTRA_FIELDS = ['extra', 'disclamer']
YT_PROXY = 'hahn'
YT_RUNNER = 'yt_runner.py'


class GenChainAdverts(sdk2.Task):
    """
    DEPRECATED: remove task after chain ad orders is properly implemented in https://st.yandex-team.ru/TYCOON-1414
    """
    class Parameters(sdk2.Task.Parameters):
        yt_token_vault = sdk2.parameters.String('YT_TOKEN vault name', required=True, default='yt_token')

        advert_source_id = sdk2.parameters.String('advert_source_id', required=True)

        chain_permalink = sdk2.parameters.String('Chain permalink', required=True)
        lang = sdk2.parameters.String('Lang', default='ru', required=True)
        priority_ = sdk2.parameters.Integer('Priority', default=0, required=True)
        title = sdk2.parameters.String('Title')
        text = sdk2.parameters.String('Text', multiline=True)
        url = sdk2.parameters.String('Url')

        use_extra = sdk2.parameters.Bool('Use extra')
        with use_extra.value[True]:
            extra = sdk2.parameters.String('Extra', multiline=True)

        use_disclamer = sdk2.parameters.Bool('Use disclamer')
        with use_disclamer.value[True]:
            disclamer = sdk2.parameters.String('Disclamer', multiline=True)

    class Requirements(sdk2.Task.Requirements):
        environments = [PipEnvironment(pkg, version=version) for pkg, version in REQUIRED_PACKAGES]

    def get_company_ids(self):
        from yt.wrapper import YtClient

        yt_token = sdk2.Vault.data(self.Parameters.yt_token_vault)
        client = YtClient(YT_PROXY, yt_token)

        with client.TempTable() as tmp_t:
            process.run_process(
                cmd=[
                    '/skynet/python/bin/python',
                    os.path.join(os.path.dirname(__file__), YT_RUNNER),
                    '--yt-proxy', YT_PROXY,
                    '--chain-permalink', self.Parameters.chain_permalink,
                    '--dst-path', tmp_t
                ],
                log_prefix=YT_RUNNER,
                wait=True,
                check=True,
                environment=dict(os.environ, YT_TOKEN=yt_token)
            )

            return {r['permalink'] for r in client.read_table(tmp_t)}

    def generate_adv_xml(self, company_ids):
        import vkbeautify as vkb
        base = (u'<?xml version="1.0" encoding="utf-8"?>\n'
                u'<AdvertInfos xmlns="http://maps.yandex.ru/advert/1.x"\n'
                u'xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"\n'
                u'xsi:schemaLocation="http://maps.yandex.ru/advert/1.x ../advert.xsd">\n'
                u'   {}\n'
                u'</AdvertInfos>')

        advert_info_template = (u'<AdvertInfo>\n'
                                u'    <company_id>{company_id}</company_id>\n'
                                u'    <priority>{priority}</priority>\n'
                                u'    {advert}\n'
                                u'</AdvertInfo>')

        def generate_advert():
            advert_template = (u'<Advert xml:lang="{lang}" xmlns="http://maps.yandex.ru/business/1.x">\n'
                               u'    {content}\n'
                               u'</Advert>\n')

            advert_content = []
            for field in ['title', 'text', 'extra', 'disclamer', 'url']:
                if field not in EXTRA_FIELDS or getattr(self.Parameters, 'use_{}'.format(field)):
                    advert_content.append((field, getattr(self.Parameters, field)))

            content = ''.join((u'<{field}>{value}</{field}>'.format(field=field, value=value)
                               for field, value in advert_content))

            return advert_template.format(lang=self.Parameters.lang, content=content)

        advert = generate_advert()
        advert_infos = []

        for company_id in company_ids:
            advert_infos.append(advert_info_template.format(
                company_id=company_id,
                priority=self.Parameters.priority_,
                advert=advert
            ))

        if not advert_infos:
            raise RuntimeError('Can not find companies of this chain ({})'.format(self.Parameters.chain_permalink))

        advert_xml = base.format(u''.join(advert_infos)).encode('utf8')
        return vkb.xml(advert_xml)

    def on_execute(self):
        company_ids = self.get_company_ids()

        resource = sdk2.ResourceData(TYCOON_AUX_ADVERTS_SOURCE(
            self, '{} advert file'.format(self.Parameters.chain_permalink),
            'adverts.xml',
            chain_permalink=self.Parameters.chain_permalink,
            n_companies=len(company_ids),
            advert_source_id=self.Parameters.advert_source_id,
            ttl=14
        ))
        resource.path.write_bytes(self.generate_adv_xml(company_ids))
