import argparse
import os

from yt.wrapper import YtClient

ALTAY_CHAIN_COMPANY_TABLE = '//home/sprav/altay/prod/snapshot/company_to_chain'
ALTAY_COMPANY_TABLE = '//home/sprav/altay/prod/snapshot/company'


class FilterByChainMapper(object):
    def __init__(self, chain_permalink):
        self.chain_permalink = chain_permalink

    def __call__(self, rec):
        if str(rec['chain_permalink']) == self.chain_permalink:
            yield {'permalink': str(rec['company_permalink']), 'type': 'target'}


def filter_by_publish_status_and_type_mapper(rec):
    if rec['publishing_status'] == 'publish' and rec['type'] == 'ordinal':
        yield {'permalink': str(rec['permalink']), 'type': 'publish'}


def target_company_extractor_reducer(key, recs):
    if len({r['type'] for r in recs}) == 2:
        yield {'permalink': key['permalink']}


def parse_args():
    parser = argparse.ArgumentParser()

    parser.add_argument('--yt-proxy', required=True)
    parser.add_argument('--yt-token', default=os.environ.get('YT_TOKEN'))
    parser.add_argument('--chain-permalink', required=True)
    parser.add_argument('--dst-path', required=True)

    return parser.parse_args()


def main():
    args = parse_args()

    client = YtClient(args.yt_proxy, args.yt_token, config={
        'pickling': {
            'python_binary': '/skynet/python/bin/python'
        }
    })

    with client.TempTable() as target_companies_tmp_t, client.TempTable() as companies_tmp_t:
        client.run_map(
            FilterByChainMapper(args.chain_permalink),
            ALTAY_CHAIN_COMPANY_TABLE,
            target_companies_tmp_t,
        )
        client.run_map(
            filter_by_publish_status_and_type_mapper,
            ALTAY_COMPANY_TABLE,
            companies_tmp_t,
        )

        client.run_map_reduce(
            None,
            target_company_extractor_reducer,
            [target_companies_tmp_t, companies_tmp_t],
            args.dst_path,
            reduce_by='permalink'
        )


if __name__ == '__main__':
    main()
