# -*- coding: utf-8 -*-
"""
    Task used to export hbf project ids from trunk to hbf
"""

# stuff from sandbox
from sandbox.sandboxsdk.process import run_process
from sandbox.sdk2 import yav

# auxiliarily gencfg stuff
from sandbox.projects.common.gencfg import utils as config_generator_utils
from sandbox.projects.common.gencfg.task import IGencfgBuildTask


class StTaskGencfg1077(IGencfgBuildTask):
    type = 'ST_TASK_GENCFG_1077'
    cores = 1
    required_ram = 8 * 1024
    execution_space = 10 * 1024

    def on_execute(self):
        config_generator_utils.clone_gencfg_all(self.get_src_path(), 'full')
        run_process(['bash', './install.sh'], work_dir=self.get_src_path(), log_prefix='install')

        secret = yav.Secret("sec-01f7rjxh61ab4sk01qe2kehdmf", "ver-01f7rjxh6gt4h1gd4t1y2006t9")

        run_process(
            [
                '/skynet/python/bin/python',
                './utils/common/manipulate_ipv4tunnels.py',
                '-a',
                'export',
                '--token',
                secret.data()["racktables-token"],
            ],
            work_dir=self.get_src_path(),
            log_prefix='export_ipv4tunnels',
        )


__Task__ = StTaskGencfg1077
