# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.task import SandboxTask

from zoom_data import regular_update_process


class GenerateGenCfgClickHouseTables(SandboxTask):
    """ Таск генерации агрегированных данных в ClickHouse.
        Берет таблицу с сырыми данными, и вычисляет кусочек таблицы с нужным уровнем агрегации
    """
    type = "GENERATE_GENCFG_CLICKHOUSE_TABLES"

    def on_enqueue(self):
        self.ctx['kill_timeout'] = 12 * 60 * 60

    def on_execute(self):
        regular_update_process(sleep_func=self.wait_time)


__Task__ = GenerateGenCfgClickHouseTables
