# coding=utf-8

import sys
import logging

import sandbox.sandboxsdk.svn as sdk_svn
import sandbox.sandboxsdk.task as sdk_task
import sandbox.sandboxsdk.parameters as sdk_parameters
import json
import collections
from xml.dom import minidom


def LoadJSON(path):
    return json.load(file(path, "rt"), object_pairs_hook=collections.OrderedDict)


class Task(sdk_task.SandboxTask):
    """ Get formula conveyor list. """

    class FmlTokenName(sdk_parameters.SandboxStringParameter):
        name = "fml_token"
        description = "Vault with FML Token"

    type = "GET_FML_CONVEYOR_AUTOFORMULAS_SNAPSHOT"
    input_parameters = [FmlTokenName]

    def on_execute(self):
        sys.path.append(sdk_svn.Arcadia.get_arcadia_src_dir("arcadia:/arc/trunk/arcadia/quality/relev_tools/conveyor_dashboard/commons"))
        import nirvana_api
        import get_file
        import conveyor_autoformulas

        url = 'https://fml.yandex-team.ru/conveyor/setup?xml'

        fml_token = self.get_vault_data('algorc_fml_token')

        conveyor_setup = get_file.GetFile.GetByCurl(url, ["Authorization: OAuth {0}".format(fml_token)], True)
        conveyor_setup_xml = minidom.parseString(conveyor_setup)

        all_af = []
        web_af = []

        for i, progress_node in enumerate(conveyor_setup_xml.getElementsByTagName('auto-formula'), 1):
            # print fml_xml_parser.FMLAutoFormula(progress_node)
            conv_auto_formula = conveyor_autoformulas.CreateFromXMLElement(progress_node)
            all_af.append(conv_auto_formula.AsDict())
            if conv_auto_formula.IsFormulator1483():
                web_af.append(conv_auto_formula.AsDict())

        logging.info(nirvana_api.enc.encode(web_af))

        # TSV MS
        with open('af_snapshot.json', 'wt') as resource_file:
            resource_file.write(nirvana_api.enc.encode(web_af))

        self.create_resource("json with fml conveyor auto-formulas snapshot", 'af_snapshot.json', 'FML_CONVEYOR_AUTO_FORMULAS_SNAPSHOT')


__Task__ = Task
