# coding=utf-8

import sys
import logging

import sandbox.sandboxsdk.svn as sdk_svn
import sandbox.sandboxsdk.task as sdk_task
import json
import collections


def LoadJSON(path):
    return json.load(file(path, "rt"), object_pairs_hook=collections.OrderedDict)


class Task(sdk_task.SandboxTask):
    """ Get formula conveyor list. """

    type = "GET_FORMULA_CONVEYORS_LIST"
    input_parameters = []

    def on_execute(self):
        sys.path.append(sdk_svn.Arcadia.get_arcadia_src_dir("arcadia:/arc/trunk/arcadia/quality/relev_tools/conveyor_dashboard/commons"))
        import nirvana_api
        import get_file

        url = "https://fml.yandex-team.ru/kosher/conveyor/list"

        resources = get_file.GetFile.GetJSONByUrllib2(url, [])

        logging.info(nirvana_api.enc.encode(resources))


__Task__ = Task
