# -*- coding: utf-8 -*-
import imp
import os

from datetime import datetime

from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.sandboxsdk.paths import make_folder
from sandbox.sandboxsdk import parameters


class AddAttributes(parameters.SandboxBoolParameter):
    name = 'add_test_params'
    description = 'Add attributes to start using resources in testing scheme'
    do_not_copy = True
    default_value = False


class GetFusionProdConfigs(SandboxTask):
    """
    The task gets production configs for fusion
    """

    type = 'GET_FUSION_PROD_CONFIGS'

    input_parameters = (AddAttributes,)

    def get_downloader(self):
        downloader_svn_url = Arcadia.trunk_url('search/fusion/tests/stand/get_prod_configs.py')
        local_downloader_path = os.path.join(self.log_path(), "get_prod_configs.py")
        Arcadia.export(downloader_svn_url, local_downloader_path)
        downloader = imp.load_source("downloader", local_downloader_path)
        return downloader

    def get_attributes(self, config):
        if not self.ctx[AddAttributes.name]:
            return {}

        attributes = {
            "test_fusion": "yes",
            "ttl": 90,
        }

        if "fresh" in config:
            attributes["test_fusion_freshness"] = "yes"

        if "samohod" in config:
            attributes["test_fusion_samohod"] = "yes"

        return attributes

    def get_timestamp(self):
        now_ts = datetime.now()
        return now_ts.strftime('%Y-%m-%d_%H:%M')

    def get_description(self, config, timestamp):
        return "[prod]{} {}".format(config, timestamp)

    def on_execute(self):
        config_dir = self.local_path("configs")
        make_folder(config_dir)
        timestamp = self.get_timestamp()

        self.downloader = self.get_downloader()
        try:
            for config, resource_type in self.downloader.CONFIGS.items():
                description = self.get_description(config, timestamp)
                path = self.downloader.get_config(config, config_dir)
                self._create_resource(description, path, resource_type, complete=1, attrs=self.get_attributes(config))
        finally:
            self.downloader = None


__Task__ = GetFusionProdConfigs
