# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.parameters import SandboxBoolParameter

from sandbox.projects.common.search.components import FUSION_WAIT_SEARCHER, FUSION_WAIT_MEMORY_FILLED

from sandbox.projects import resource_types
from sandbox.projects.common.base_search_quality import response_saver
from sandbox.projects.common.base_search_quality import threadPool
from sandbox.projects.websearch.basesearch.GetBasesearchResponses import PoliteModeParameter, PatchRequestThreadsParameter, RelevanceThreadsParameter
from sandbox.projects.common.fusion.task import FusionTestTask
from sandbox.projects.common.fusion.task import FusionParamsDescription
from sandbox.projects.common.fusion.response_patcher import response_patcher
from sandbox.projects.common.fusion.params import PatchQueries, get_query_patcher

import time


class WaiForIndexAfterFeed(SandboxBoolParameter):
    name = 'wait_for_index_after_feed'
    description = 'Wait for disk index creation after feeding dump'
    default_value = False


class PatchResponses(SandboxBoolParameter):
    name = 'patch_responses'
    description = 'Patch resulting responses to remove changing values'
    default_value = True


class WriteEventLog(SandboxBoolParameter):
    name = 'write_eventlog'
    description = 'Write eventlog (can slowdown fusion)'
    default_value = False


class GetFusionResponses(FusionTestTask):
    """
    An analogue of GET_BASESEARCH_RESPONSES with fusion specific taken into account
    """
    type = 'GET_FUSION_RESPONSES'

    input_parameters = (
        PoliteModeParameter,
        PatchRequestThreadsParameter,
        RelevanceThreadsParameter, WaiForIndexAfterFeed, PatchResponses, WriteEventLog, PatchQueries
    ) + FusionTestTask.input_parameters + response_saver.DefaultResponseSaverParams.params + threadPool.PARAMS

    execution_space = 120000

    def on_enqueue(self):
        resource = self._create_resource(
            self.descr,
            "basesearch_responses.txt",
            resource_types.BASESEARCH_HR_RESPONSES
        )
        self.ctx['out_resource_id'] = resource.id

    def on_execute(self):
        distributor = None
        wait_function = FUSION_WAIT_SEARCHER
        if self.use_distributor():
            distributor = self.get_distributor()
            wait_function = FUSION_WAIT_MEMORY_FILLED

        fusion = self.get_fusion(
            get_db=self.is_db_resource_required(),
            max_documents=self.get_max_docs(),
            default_wait=wait_function,
            run=False,
            event_log=self.ctx[WriteEventLog.name]
            )
        out_resource = channel.sandbox.get_resource(self.ctx['out_resource_id'])

        def wait_after_start():
            time.sleep(10)

        on_start_get_responses_callback = wait_after_start
        prepare_session_callback = None

        if not self.is_db_resource_required():
            on_start_get_responses_callback = self.get_memorysearch_callback(fusion)
            prepare_session_callback = self.get_cleanup_dir_callback(fusion)

        patchers = [response_patcher] if self.ctx[PatchResponses.name] else []
        query_patchers = [get_query_patcher(self.ctx[PatchQueries.name])] if self.ctx[PatchQueries.name] else []

        response_saver.save_responses(
            self.ctx,
            search_component=fusion,
            response_patchers=patchers,
            responses_resource=out_resource,
            relevance_threads=self.ctx['relevance_threads'],
            on_start_get_responses=on_start_get_responses_callback,
            prepare_session_callback=prepare_session_callback,
            factor_names=True,
            on_end_get_responses=self.get_doc_size_callback(fusion),
            queries_patchers=query_patchers,
        )

        if distributor is not None:
            distributor.stop()


GetFusionResponses.__doc__ += FusionParamsDescription
__Task__ = GetFusionResponses
