# -*- coding: utf-8 -*-

import os
import shutil

from sandbox import sdk2

from sandbox.projects.common import error_handlers
from sandbox.projects.market.resources import MARKET_DATA_HYPER_CAT_ID

import logging


class GetHyperCatId(sdk2.Task):
    """
        Скачивает ресурс из sandbox таски и коммитит его в аркадию.
    """

    name = 'GET_HYPER_CAT_ID'

    class Parameters(sdk2.Task.Parameters):
        target_path = sdk2.parameters.String('Target path for commit', default='/quality/user_sessions/market/market_sessions_stat/resources/hyper_cat_id.pb', required=True)
        author = sdk2.parameters.String('Author of commit', default='zomb-sandbox-rw', required=True)

    def on_execute(self):
        dst_name = os.path.basename(self.Parameters.target_path)
        fresh_resource = sdk2.Resource.find(MARKET_DATA_HYPER_CAT_ID, attrs={"released": "stable"}).first()
        svn_url = sdk2.svn.Arcadia.trunk_url(self.Parameters.target_path)
        svn_dir = sdk2.svn.Arcadia.get_arcadia_src_dir(os.path.dirname(svn_url))
        error_handlers.verify(svn_dir, "Commit directory set by target_path parameter should not be None. Maybe path {} does not exist".format(self.Parameters.target_path))
        svn_dir = str(svn_dir)

        sync_path = str(sdk2.ResourceData(fresh_resource).path)
        logging.info("Resource %s, res_id %s; url %s; dir %s; sync_path %s", fresh_resource, fresh_resource.id, svn_url, svn_dir, sync_path)

        shutil.copy(os.path.join(sync_path, 'mbo_fast/tovar-tree.pb'), os.path.join(svn_dir, os.path.basename(dst_name)))
        svn_list = sdk2.svn.Arcadia.list(svn_dir).split()
        if dst_name not in svn_list:
            sdk2.svn.Arcadia.add(os.path.join(svn_dir, dst_name))
        logging.info('ARCADIA STATUS...\n%s', sdk2.svn.Arcadia.status(svn_dir))
        logging.info("ARCADIA DIFF...\n%s", sdk2.svn.Arcadia.diff(svn_dir))

        comment = "{} update {} resource file\nhttps://sandbox.yandex-team.ru/task/{}/view\nSKIP_REVIEW\nSKIP_CHECK".format(self.type, dst_name, self.id)
        sdk2.svn.Arcadia.commit(svn_dir, comment, self.Parameters.author)
