# -*- coding: utf-8 -*-_read_resource

import os
import logging
import tarfile

import sandbox.sandboxsdk.task as sdk_task
import sandbox.sandboxsdk.copy as sdk_copy
import sandbox.sandboxsdk.paths as sdk_paths
import sandbox.sandboxsdk.process as sdk_process

from sandbox.sandboxsdk.parameters import LastReleasedResource
from sandbox.sandboxsdk.channel import channel

from sandbox.projects import resource_types

from urlparse import urlparse

I2T_FILES = [
    "i2t_ver7_fall2016_clickbase_char_trigrams_dict_uniq.tsv",
    "i2t_ver7_fall2016_clickbase_words_bigrams_dict_uniq.tsv",
    "i2t_ver7_fall2016_clickbase_words_dict_uniq.tsv",
    "i2t_v11_char_fivegrams_dict.tsv",
    "i2t_v11_char_fourgrams_dict.tsv",
    "i2t_v11_char_trigrams_dict.tsv",
    "i2t_v11_word_bigrams_dict_primary.tsv",
    "i2t_v11_word_bigrams_dict_secondary.tsv",
    "i2t_v11_words_dict_primary.tsv",
    "i2t_v11_words_dict_secondary.tsv",
    "i2t_v12_bpe_data.mmap",
    "i2t_v12_bpe_dict.mmap",
    "i2t_v12_char_fivegrams_dict.tsv",
    "i2t_v12_char_fourgrams_dict.tsv",
    "i2t_v12_char_trigrams_dict.tsv",
    "i2t_v12_word_bigrams_dict.tsv",
    "i2t_v12_word_unigrams_dict.tsv",
    "i2t_ver8_txt_prod.cfg",
    "i2t_ver8_txt_prod.net",
    "i2t_ver9_txt_prod.cfg",
    "i2t_ver9_txt_prod.net",
    "i2t_ver10_txt_prod.cfg",
    "i2t_ver10_txt_prod.net",
    "i2t_ver11_txt_prod.cfg",
    "i2t_ver11_txt_prod.net",
    "i2t_ver12_txt_prod.cfg",
    "i2t_ver12_txt_prod.net",
    "i2t_ver13_txt_prod.cfg",
    "i2t_ver13_txt_prod.net",
]

CONFIG_FILES = {
    "areas.lst": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/urlrules/areas.lst",
    "child-porn-ocr-dictionary.txt": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/child-porn-ocr-dictionary.txt",
    "fio.trie": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/fio.trie",
    "geoa.c2p": "IMAGES_GEOA_C2P",
    "hl.data": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/hl.data",
    "i2t.v5.clusters.protobin": "IMAGES_INDEX_I2T_V5_CLUSTERS",
    "a2a_ver1_txt_prod.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/a2a_ver1_txt_prod.cfg",
    "a2a_ver1_txt_prod.net": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/a2a_ver1_txt_prod.net",
    "t2t_doc.dssm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/t2t_doc.dssm",
    "t2t_query.dssm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/t2t_query.dssm",
    "t2t_v3_doc.dssm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/t2t_v3_doc.dssm",
    "t2t_v3_query.dssm": "IMAGES_T2T_QUERY_MODEL",
    "doc2profile.dssm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/formulas/doc2profile/doc2profile.dssm",
    "doc2profile.profile.dssm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/formulas/doc2profile/doc2profile.profile.dssm",
    "profile_images_history2doc.dssm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/formulas/images_history/profile_images_history2doc.dssm",
    "formula-web-clickrank.info": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/formulas/recommender/formula-web-clickrank.info",
    "import.trie": "IMAGES_IMPORT_TRIE",
    "link_text_junk_patterns.trie": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/link_text_junk_patterns.trie",
    "lrlang.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/wizard/language/lrlang.cfg",
    "meta": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/meta",
    "indexpanther.offroad.key.model": "IMAGES_PANTHER_OFFROAD_INDEX_KEY_MODEL",
    "indexpanther.offroad.inv.model": "IMAGES_PANTHER_OFFROAD_INDEX_INV_MODEL",
    "pentagrams.txt": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/pentagrams.txt",
    "pure": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/wizard/language/pure",
    "queries_dump_img_Russia.bin": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/queries_dump_img_Russia.bin",
    "queries_dump_img_Turkey.bin": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/queries_dump_img_Turkey.bin",
    "queryrec.dict": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/wizard/language/queryrec.dict",
    "queryrec.filters": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/wizard/language/queryrec.filters",
    "queryrec.weights": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/wizard/language/queryrec.weights",
    "ratedcrcs.txt": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/ratedcrcs.txt",
    "ratedurlshashes.bin": "IMAGES_RATED_URL_HASHES",
    "ratedpages.txt": "IMAGES_RATED_PAGE_URLS",
    "ratings.tsv.gz": "http://fml.yandex-team.ru/api/get/images.ru/ratings.tsv.gz",
    "relev_regions.txt": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/relev_regions.txt",
    "requests.ImgTier0.tsv.gz": "http://fml.yandex-team.ru/api/get/images.ru/requests.ImgTier0.tsv.gz",
    "series.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/series.cfg",
    "spok_quota.txt": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/spok_quota.txt",
    "stopurlp.txt": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/stopurlp.txt",
    "stopword.lst": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/wizard/language/stopword.lst",
    "stopwords.txt": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/stopwords.txt",
    "t2t.clusters.protobin": "IMAGES_INDEX_T2T_CLUSTERS",
    "vowpal-wabbit-packed-dwell-time-model.bin": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/vowpal-wabbit-packed-dwell-time-model.bin",
    "vowpal-wabbit-packed-gruesome-model.bin": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/vowpal-wabbit-packed-gruesome-model.bin",
    "vowpal-wabbit-packed-porn-model.bin": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/vowpal-wabbit-packed-porn-model.bin",
    "vowpal-wabbit-packed-suggestive-model.bin": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/vowpal-wabbit-packed-suggestive-model.bin",
    "vowpal-wabbit-packed-cp-model.bin": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/vowpal-wabbit-packed-cp-model.bin",
    "vowpal-wabbit-packed-ann-gruesome-model.bin": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/vowpal-wabbit-packed-ann-gruesome-model.bin",
    "vowpal-wabbit-packed-ann-porn-model.bin": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/vowpal-wabbit-packed-ann-porn-model.bin",
    "vowpal-wabbit-packed-ann-suggestive-model.bin": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/vowpal-wabbit-packed-ann-suggestive-model.bin",
    "vowpal-wabbit-packed-ann-cp-model.bin": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/vowpal-wabbit-packed-ann-cp-model.bin",
    "vowpal-wabbit-sr-model.bin": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/vowpal-wabbit-sr-model.bin",
    "vowpal-wabbit-url-porn-model.bin": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/vowpal-wabbit-url-porn-model.bin",
    "spam_model.cbm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/spam_model.cbm",
    "spam_model_beta.cbm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/spam_model_beta.cbm",
    "spam_model.fstr": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/spam_model.fstr",
    "cp_model.cbm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/cp_model.cbm",
    "cp_model_beta.cbm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/cp_model_beta.cbm",
    "gruesome_model.cbm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/gruesome_model.cbm",
    "gruesome_model_beta.cbm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/gruesome_model_beta.cbm",
    "porn_model.cbm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/porn_model.cbm",
    "porn_model_beta.cbm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/porn_model_beta.cbm",
    "suggestive_model.cbm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/suggestive_model.cbm",
    "suggestive_model_beta.cbm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/suggestive_model_beta.cbm",
    "wikimedia.txt": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/wikimedia.txt",
    "dssm_q2t_doc.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/dssm_q2t_doc.cfg",
    "dssm_q2t_doc.net": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/dssm_q2t_doc.net",
    "dssm_q2t_query.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/dssm_q2t_query.cfg",
    "dssm_q2t_query.net": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/dssm_q2t_query.net",
    "dssm_q2t_trigrams_dict.tsv": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/dssm_q2t_trigrams_dict.tsv",
    "dssm_q2t_words_dict.tsv": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/dssm_q2t_words_dict.tsv",
    "nnsimilar_v5_toloka.vocab": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nnsimilar_v5_toloka.vocab",
    "nnsimilar_v6_toloka.vocab": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nnsimilar_v6_toloka.vocab",
    "nnsimilar_v7_toloka.vocab": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nnsimilar_v7_toloka.vocab",
    "nnsimilar_v8_toloka.vocab": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nnsimilar_v8_toloka.vocab",
    "nnsimilar_v8_clothes.vocab": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nnsimilar_v8_clothes.vocab",
    "nnsimilar_raw_v9_clothes.vocab": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nnsimilar_raw_v9_clothes.vocab",
    "nnsimilar_raw_v9_clothes.vocab.hnsw": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nnsimilar_raw_v9_clothes.vocab.hnsw",
    "nnsimilar_raw_v10_clothes_v6.vocab": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nnsimilar_raw_v10_clothes_v6.vocab",
    "nnsimilar_v9_toloka.vocab": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nnsimilar_v9_toloka.vocab",
    "nnsimilar_raw_v10_toloka.vocab": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nnsimilar_raw_v10_toloka.vocab",
    "nnsimilar_raw_v10_toloka.vocab.hnsw": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nnsimilar_raw_v10_toloka.vocab.hnsw",
    "nnsimilar_raw_v12_toloka.vocab": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nnsimilar_raw_v12_toloka.vocab",
    "nnsimilar_raw_v12_toloka.vocab.hnsw": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nnsimilar_raw_v12_toloka.vocab.hnsw",
    "nnsimilar_v6_clothes_v2.vocab": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nnsimilar_v6_clothes_v2.vocab",
    "nnsimilar_v6_clothes_v3.vocab": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nnsimilar_v6_clothes_v3.vocab",
    "nnsimilar_face_v2.vocab": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nnsimilar_face_v2.vocab",
    "nnsimilar_face_v3.vocab": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nnsimilar_face_v3.vocab",
    "nnsimilar_face_v4.vocab": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nnsimilar_face_v4.vocab",
    "nnsimilar_raw_face_v5.vocab": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nnsimilar_raw_face_v5.vocab",
    "nnsimilar_raw_face_v6.vocab": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nnsimilar_raw_face_v6.vocab",
    "nnsimilar_raw_face_v6.vocab.hnsw": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nnsimilar_raw_face_v6.vocab.hnsw",
    "nnsimilar_raw_v10_market.vocab": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nnsimilar_raw_v10_market.vocab",
    "nnsimilar_raw_v10_market.vocab.hnsw": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nnsimilar_raw_v10_market.vocab.hnsw",
    "nnsimilar_raw_v11_market.vocab": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nnsimilar_raw_v11_market.vocab",
    "nnsimilar_raw_v11_market.vocab.hnsw": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nnsimilar_raw_v11_market.vocab.hnsw",
    "nnsimilar_raw_v12_market.vocab": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nnsimilar_raw_v12_market.vocab",
    "main_selection_rank.info": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/formulas/sr/main_selection_rank.info",
    "fast_selection_rank.info": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/formulas/sr/fast_selection_rank.info",
    "indexannimg.offroad.model": "IMAGES_INVINDEX_OFFROAD_MODEL_ARCHIVE",
    "key_bounds.txt": "IMAGES_PANTHER_COUNTS_KEY_BOUNDS",
    "frequent_keys.txt": "IMAGES_PANTHER_FREQUENT_KEYS",
    "merge_tags_compress_link.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/merge_tags_compress_link.cfg",
    "merge_tags_compress_link.model": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/merge_tags_compress_link.model",
    "images_tags_mmeta_models_bundle": "IMAGES_TAGS_MMETA_MODELS_BUNDLE",
    "linkselector_metadoc_v4.model": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/formulas/link_selector/linkselector_metadoc_v4.model",
    "linkselector_metadoc_v5.model": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/formulas/link_selector/linkselector_metadoc_v5.model",
    "linkselector_commercial_metadoc_v2.model": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/formulas/link_selector/linkselector_commercial_metadoc_v2.model",
    "linkselector_commercial_metadoc_v3.model": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/formulas/link_selector/linkselector_commercial_metadoc_v3.model",
    "linkselector_meta_commercial_metadoc.model": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/formulas/link_selector/linkselector_meta_commercial_metadoc.model",
    "linkselector_meta_commercial_metadoc_v2.model": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/formulas/link_selector/linkselector_meta_commercial_metadoc_v2.model",
    "surf.trie": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/surf.trie",
    "nn_over_dssm_v1_doc.pb": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nn_over_dssm_v1_doc.pb",
    "nn_over_dssm_v1_query.pb": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nn_over_dssm_v1_query.pb",
    "urlless_hosts_whitelist.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/urlless_hosts_whitelist.cfg",
    "query_title_url_embedding.adssm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/query_title_url_embedding.adssm",
    "model_market_title.cbm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/model_market_title.cbm",
    "dssm_bert_distill_relevance_mse.dssm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/dssm_bert_distill_relevance_mse.dssm",
    "dssm_bert_distill_relevance_mse_query.dssm": "IMAGES_BERT_DISTILL_QUERY_MODEL",
    "usefulness_small.cbm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/usefulness_small.cbm",
    "model_one_product_title_url.cbm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/model_one_product_title_url.cbm",
    "hard2_doc_embedding.adssm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/hard2_doc_embedding.adssm",
    "hard2_query.dssm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/hard2_query.dssm",
    "reformulation_doc_embedding.adssm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/reformulation_doc_embedding.adssm",
    "reformulation_query.dssm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/reformulation_query.dssm",
    "link_instock.cbm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/link_instock.cbm",
    "query_interior_prob_v1.cbm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/search/web/rearrange/imgqueryfactors/query_interior_prob_v1.cbm",
    "query_clothes_v2.cbm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/query_clothes_v2.cbm",
    "query_commercial_v5.cbm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/query_commercial_v5.cbm",
    "commodity_categories_characteristics.json": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/commodity_categories_characteristics.json",
    "brands_hyperscan_db.bin": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/brands_hyperscan_db.bin"
}

for f in I2T_FILES:
    CONFIG_FILES[f] = "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/" + f

OPTIONAL_CONFIG_FILES = {
    "nn_over_dssm_experimental_doc.pb": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nn_over_dssm_experimental_doc.pb",
    "nn_over_dssm_experimental_query.pb": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/nn_over_dssm_experimental_query.pb"
}

SHARDWRITER_FILES = I2T_FILES + [
    "geoa.c2p",
    "geodata4.bin",
    "meta",
    "queryrec.dict",
    "queryrec.filters",
    "queryrec.weights",
    "ratings.tsv.gz",
    "relev_regions.txt",
    "requests.ImgTier0.tsv.gz",
    "indexpanther.offroad.key.model",
    "indexpanther.offroad.inv.model",
    "indexannimg.offroad.model",
    "i2t.v5.clusters.protobin",
    "a2a_ver1_txt_prod.cfg",
    "a2a_ver1_txt_prod.net",
    "dssm_q2t_query.cfg",
    "dssm_q2t_query.net",
    "dssm_q2t_trigrams_dict.tsv",
    "dssm_q2t_words_dict.tsv",
    "t2t.clusters.protobin",
    "t2t_query.dssm",
    "t2t_v3_query.dssm",
    "dssm_bert_distill_relevance_mse_query.dssm",
    "merge_tags_compress_link.cfg",
    "merge_tags_compress_link.model",
    "images_tags_mmeta_models_bundle",
    "frequent_keys.txt",
    "nn_over_dssm_v1_doc.pb",
    "nn_over_dssm_v1_query.pb",
    "hard2_query.dssm",
    "hard2_doc_embedding.adssm",
    "reformulation_doc_embedding.adssm",
    "reformulation_query.dssm"
]


class IndexConfigChecker(LastReleasedResource):
    name = 'config_checker'
    description = 'Config checker binary'
    resource_type = 'IMAGES_MR_INDEX_CONFIG_CHECKER'


class GetImagesMrIndexConfig(sdk_task.SandboxTask):
    type = 'GET_IMAGES_MR_INDEX_CONFIG'

    input_parameters = [IndexConfigChecker]
    execution_space = 50 * 1024  # 50 Gb

    def on_execute(self):
        logging.info('Get resource object')
        resource_id = self.create_resource(
            "images mrindex config", 'config',
            resource_types.IMAGES_MR_INDEX_CONFIG,
        ).id
        resource = channel.sandbox.get_resource(resource_id)
        self.dst_folder = resource.path
        sdk_paths.make_folder(self.dst_folder, True)

        self._fill_mrindex_resource()
        self._create_sw_resource()
        self._check_config_files()

        channel.task.mark_resource_ready(resource)

    def _check_config_files(self):
        config_checker_path = self.sync_resource(self.ctx["config_checker"])
        sdk_process.run_process([config_checker_path, "--path", self.dst_folder],
                                log_prefix="config_checker",
                                timeout=600, wait=True, check=True)

    def _fill_mrindex_resource(self):
        sdk_paths.make_folder(self.dst_folder, True)

        for filename, src_path in CONFIG_FILES.iteritems():
            self._get_file(filename, src_path)

        for filename, src_path in OPTIONAL_CONFIG_FILES.iteritems():
            try:
                self._get_file(filename, src_path)
            except:
                pass

        self._download_geobase4()

    def _get_file(self, filename, src_path):
        dst_path = os.path.join(self.dst_folder, filename)
        if isinstance(src_path, dict):
            attributes = src_path["attributes"]
            src_path = src_path["type"]
            self._get_from_resource(src_path, dst_path, attributes=attributes)
        else:
            parsed_url = urlparse(src_path)
            if parsed_url.scheme:
                self._download_file(src_path, dst_path)
            else:
                self._get_from_resource(src_path, dst_path)

    def _download_file(self, src, dst):
        sdk_copy.RemoteCopy(src,
                            dst,
                            log_dir=self.log_path())(timeout=sdk_copy.RemoteCopy.DEFAULT_TIMEOUT)

    def _get_from_resource(self, src, dst, attributes=None):
        try:
            resource_id = None
            if attributes:
                if "released" not in attributes:
                    attributes["released"] = "stable"
                resource_id = channel.sandbox.list_resources(resource_type=src,
                                                             limit=1,
                                                             all_attrs=attributes)[0].id
            else:
                resource_id = channel.sandbox.list_releases(resource_type=src,
                                                            limit=1)[0].resources[0].id
            resource_path = self.sync_resource(resource_id)
            sdk_paths.copy_path(resource_path, dst)
        except IndexError:
            raise RuntimeError("Can not find release for resource {}.".format(src))

    def _download_geobase4(self):
        from projects.geobase.Geodata4BinStable.resource import GEODATA4BIN_STABLE
        resource_id = channel.sandbox.list_releases(
            GEODATA4BIN_STABLE, limit=1)[0].resources[0].id
        resource_path = self.sync_resource(resource_id)
        with tarfile.open(resource_path) as tar:
            tar.extractall(path=self.dst_folder)

    def _create_sw_resource(self):
        sw_resource_id = self.create_resource(
            "images sw config",
            "sw_config",
            resource_types.IMAGES_SHARDWRITER_CONFIG
        ).id
        sw_resource = channel.sandbox.get_resource(sw_resource_id)

        for filename in SHARDWRITER_FILES:
            src_path = os.path.join(self.dst_folder, filename)
            dst_path = os.path.join(sw_resource.path, filename)
            sdk_paths.copy_path(src_path, dst_path)


__Task__ = GetImagesMrIndexConfig
