# -*- coding: utf-8 -*-

import sandbox.common.types.client as ctc
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.channel import channel

from sandbox.projects.common.base_search_quality.response_saver import save_responses
from sandbox.projects.common.base_search_quality.response_saver import DefaultResponseSaverParams
from sandbox.projects.common.base_search_quality import threadPool

from sandbox.projects.common.geosearch.search_components import get_addrs_basesearch_params
from sandbox.projects.common.geosearch.search_components import get_addrs_basesearch_business
from sandbox.projects.common.geosearch.response_parser import GetGeosearchCustomNodeTypesDict
from sandbox.projects.common.geosearch.response_parser import GeosearchResponsePatcher


class GetMapsSearchBusinessResponses(SandboxTask):
    """
        Start new maps-search-business instance from arcadia
    """
    type = 'GET_MAPS_SEARCH_BUSINESS_RESPONSES'

    client_tags = ctc.Tag.Group.LINUX
    cores = 17

    MapsSearchBusinessParams = get_addrs_basesearch_params()

    input_parameters = (
        DefaultResponseSaverParams.params +
        threadPool.PARAMS +
        MapsSearchBusinessParams.params
    )

    def on_enqueue(self):
        SandboxTask.on_enqueue(self)

        self.ctx['out_resource_id'] = self._create_resource(
            self.descr,
            'responses.txt',
            'BASESEARCH_HR_RESPONSES',
            arch='any'
        ).id

        self.ctx['patched_queries_resource_id'] = self._create_resource(
            'patched queries',
            'patched_queries.txt',
            'PLAIN_TEXT_QUERIES',
            arch='any'
        ).id

    def on_execute(self):

        def patch_query(q):
            q = q.replace('&hr=da', '')
            return q + '&hr=yes&gta=_RankingFactors'

        def disable_degradation(q):
            idx = q.find('&pron=smautodegrade')
            if idx == -1:
                idx = q.find('?pron=smautodegrade')
            if idx == -1:
                return q
            idx_end = q.find('&', idx + 1)
            if idx_end == -1:
                return q[:(idx + 1)]
            return q[:(idx + 1)] + q[(idx_end + 1):]

        def add_timestamp_to_relev(q):
            RELEV_TS = 'ts%3D1439467641'
            cgiNewParameters = []
            cgiParameters = q[1:].split('&')
            added = False
            for cgi in cgiParameters:
                if len(cgi) == 0:
                    continue
                if '=' in cgi:
                    name, val = cgi.split('=', 1)
                    if name == 'relev' and not added:
                        val += ';' + RELEV_TS
                        added = True
                    cgiNewParameters.append(name + '=' + val)
                else:
                    cgiNewParameters.append(cgi)

            # There was no relev
            if not added:
                cgiNewParameters.append('relev=' + RELEV_TS)

            return '?' + '&'.join(cgiNewParameters)

        out_resource = channel.sandbox.get_resource(self.ctx['out_resource_id'])
        patched_queries = channel.sandbox.get_resource(self.ctx['patched_queries_resource_id'])
        component = get_addrs_basesearch_business(self.ctx)
        save_responses(
            self.ctx,
            search_component=component,
            queries_patchers=[patch_query, disable_degradation, add_timestamp_to_relev],
            responses_resource=out_resource,
            custom_node_types_dict=GetGeosearchCustomNodeTypesDict(),
            response_patchers=[GeosearchResponsePatcher],
            patched_queries_resource=patched_queries,
            transform_if_response_is_xml=True,
        )


__Task__ = GetMapsSearchBusinessResponses
