# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.errors import SandboxTaskFailureError

from sandbox.projects.common.BaseGetShardmapTask import BaseGetShardmapTask
from sandbox.projects.common.BaseGetShardmapTask import ShardmapResourceType
from sandbox.projects import resource_types


class GetMediaShardmapFromSvnTask(BaseGetShardmapTask):
    """
        Скачивает шардмап картиночных тумбнейлов по SVN урлу
    """
    type = 'GET_MEDIA_SHARDMAP_FROM_SVN'

    def initCtx(self):
        self.ctx['kill_timeout'] = 15 * 60

    def _get_shardmap_resource_type(self):
        try:
            return getattr(resource_types, self.ctx[ShardmapResourceType.name])
        except AttributeError:
            raise SandboxTaskFailureError(
                "Unknown resource type: %s" %
                (self.ctx[ShardmapResourceType.name]))


__Task__ = GetMediaShardmapFromSvnTask
