# -*- coding: utf-8 -*-

import sandbox.common.types.client as ctc

from sandbox.projects import resource_types
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk import paths

from sandbox.projects.common.base_search_quality import response_saver
from sandbox.projects.common.news.newsd import SlaveNewsd, create_newsd_params


class GetNewsdResponses(SandboxTask):
    """
        Получает и сохраняет результаты обстрела slave_newsd
    """
    type = 'GET_NEWSD_RESPONSES'
    client_tags = ctc.Tag.Group.LINUX

    newsd_params = create_newsd_params()
    input_parameters = \
        newsd_params.params \
        + response_saver.DefaultResponseSaverParams.params

    def on_enqueue(self):
        SandboxTask.on_enqueue(self)
        resource = self.create_resource(
            self.descr,
            "newsd_responses.txt",
            resource_types.BASESEARCH_HR_RESPONSES
        )
        self.ctx['out_resource_id'] = resource.id

    def on_execute(self):
        out_resource = channel.sandbox.get_resource(self.ctx['out_resource_id'])

        workdir = self.path('work')
        paths.make_folder(workdir, True)
        port = 17171

        queries_patchers = []

        def remove_debug(q):
            return q.replace(";newsd_debug%3D1", "")
        queries_patchers.append(remove_debug)

        timestamp = channel.sandbox.get_resource_attribute(
            self.ctx[self.newsd_params.StateDump.name],
            attribute_name="timestamp",
        )

        newsd = SlaveNewsd(
            workdir=workdir,
            binary=self.sync_resource(self.ctx[self.newsd_params.Binary.name]),
            cfg=self.sync_resource(self.ctx[self.newsd_params.Config.name]),
            port=port,
            state=self.sync_resource(self.ctx[self.newsd_params.StateDump.name]),
            geobase=self.sync_resource(self.ctx[self.newsd_params.Geobase.name]),
            index_config_path=self.sync_resource(self.ctx[self.newsd_params.IndexConfig.name]),
            now=timestamp,
        )

        response_saver.save_responses(
            self.ctx,
            search_component=newsd,
            responses_resource=out_resource,
            queries_patchers=queries_patchers,
            need_max_timeout=False,
            need_dbgrlv=False,
        )


__Task__ = GetNewsdResponses
