# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.parameters import LastReleasedResource
from sandbox.sandboxsdk.parameters import SandboxIntegerParameter
from sandbox.sandboxsdk.parameters import SandboxBoolParameter
from sandbox.sandboxsdk.channel import channel

from sandbox.projects.common import utils
from sandbox.projects.common import dolbilka


class PlanParameter(LastReleasedResource):
    name = 'plan_resource_id'
    description = 'Plan'
    resource_type = ['BASESEARCH_PLAN', 'MIDDLESEARCH_PLAN', 'IMAGES_MIDDLESEARCH_PLAN', 'VIDEO_MIDDLESEARCH_PLAN']


class NumQueriesParameter(SandboxIntegerParameter):
    name = 'num_queries'
    description = 'Number of queries (0-all)'
    default_value = 0


class StoreCollectionParameter(SandboxBoolParameter):
    """
        Store collection in resulting queries
    """
    name = 'store_collection'
    description = 'Store collection in query'
    default_value = False


class GetQueriesFromPlan(SandboxTask):
    """
        Gets queries from plan by runnung d-executor -p plan -D -Q
        and parsing its stdout
    """

    type = 'GET_QUERIES_FROM_PLAN'

    input_parameters = (
        PlanParameter,
        NumQueriesParameter,
        StoreCollectionParameter
    )

    def on_enqueue(self):
        SandboxTask.on_enqueue(self)

        self.ctx['out_resource_id'] = self.create_resource(
            self.descr,
            'queries.txt',
            'PLAIN_TEXT_QUERIES',
            arch='any'
        ).id

    def on_execute(self):
        queries_res = channel.sandbox.get_resource(self.ctx['out_resource_id'])

        self.sync_resource(self.ctx[PlanParameter.name])
        plan_res = channel.sandbox.get_resource(self.ctx[PlanParameter.name])

        number_of_queries = dolbilka.get_queries_from_plan(
            plan_res.path,
            queries_res.path,
            self.ctx[NumQueriesParameter.name],
            utils.get_or_default(self.ctx, StoreCollectionParameter),
        )
        self.set_info("number of queries: {}".format(number_of_queries))


__Task__ = GetQueriesFromPlan
