import argparse
import requests
import json


RTMR_SERVER = (
    "http://rtmr.search.yandex.net:8080/api/v2/data.json?path=active_keys&id=user_actions_json&showsubkey=1&maxrecords=1000"
)


def main(count):
    from runtime import queries

    server = queries.SearchUrl(RTMR_SERVER)
    server.query['maxrecords'] = count if count <= 1000 else 1000
    remote = requests.get(server.string)
    uids = ['%s' % entry["Value"] for entry in json.loads(remote.text.strip())["Chunks"][0]["Entries"]]
    uids = list(filter(lambda uid: uid.isdigit(), uids))
    uids = (uids * (count / len(uids) + 1))[:count]
    return uids


def create_parser():
    parser = argparse.ArgumentParser()
    parser.add_argument('--count', required=True, type=int, default=1000)
    parser.add_argument('--out-file', required=False)
    return parser


if __name__ == "__main__":
    parser = create_parser()
    args = parser.parse_args()
    print "\n".join(main(args.count))
    if args.out_file:
        open(args.out_file, "w").write("\n".join(main(args.count)))
