# coding: utf-8

import logging
import requests
import json
import os

import sandbox.common.errors as errors

from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.errors import SandboxTaskFailureError
from sandbox.sandboxsdk.task import SandboxTask


_RESOURCE_TYPE = 'SEARCH_DATABASE'  # TODO Change


class GetRefreshIndexForTest(SandboxTask):
    """Создаёт ресурс с индексом для тестирования рефреша"""

    type = 'GET_REFRESH_INDEX_FOR_TEST'

    def _send_command(self, parameters):
        command = parameters['command']
        server_protocol = 'http'
        server_name = 'sas1-8833.search.yandex.net'
        server_port = 7303
        server_request_adress = '{}://{}:{}'.format(
            server_protocol,
            server_name,
            server_port
        )
        r = requests.get(server_request_adress, params=parameters)

        logging.debug('Answer for command:{}'.format(command))
        logging.debug(r.text)

        if r.status_code != 200:
            raise errors.TemporaryError('Anwser error not 200')

        answer = json.loads(r.text)

        if answer['task_status'] != 'FINISHED':
            raise errors.TemporaryError('Anwser error not FINISHED')

        return answer

    def on_execute(self):

        commands = [
            'disable_search',
            'pause_docfetcher',
            'synchronizer',
            'continue_docfetcher',
            'enable_search'
        ]

        for command in commands:
            logging.debug('Start exec command: {}'.format(command))
            params = {}
            params['command'] = command
            if command == 'synchronizer':
                params['action'] = 'detach'
                params['min_shard'] = 0
                params['max_shard'] = 65533
                params['sharding_type'] = 'url'

            try:
                answer = self._send_command(params)
            except:
                self._send_command({'command': 'continue_docfetcher'})
                self._send_command({'command': 'enable_search'})

            if command == 'synchronizer':
                logging.debug('Start copy {}'.format(answer['id_res']))

                res_rbtorrent = answer['id_res']

                fetched = self.path('fetched_index')
                self.remote_copy(res_rbtorrent,
                                 fetched,
                                 create_resource=False
                                 )
                folders = os.listdir(fetched)
                if len(folders) == 1 and not folders[0].startswith('index_00'):
                    index_path = os.path.join(fetched, folders[0])
                else:
                    index_path = fetched
                max_size = 0
                biggest_shard = ''
                shards = [os.path.join(index_path, p) for p in os.listdir(index_path)]
                shards = [s for s in shards if os.path.isdir(s)]
                for ind_shard in shards:
                    sh_files = [os.path.join(ind_shard, p) for p in os.listdir(ind_shard)]
                    sh_size = 0
                    for shf in sh_files:
                        sh_size += os.stat(shf).st_size
                    if sh_size > max_size:
                        max_size = sh_size
                        biggest_shard = ind_shard
                if max_size > 70 * 10**9:
                    channel.sandbox.send_email('anikella', '', 'Too big refresh index', self.http_url())
                    raise SandboxTaskFailureError('Too big index, %s bytes' % max_size)

                self._create_resource('Copy index',
                                      biggest_shard,
                                      _RESOURCE_TYPE,
                                      attrs={'refresh_test_base': 'yes',
                                             'test_fusion': 'yes'},
                                      complete=1)


__Task__ = GetRefreshIndexForTest
