# -*- coding: utf-8 -*-

import logging

from sandbox.projects import resource_types
from sandbox.projects.common.search.database import iss_shards
from sandbox.projects.common.search import settings as mset
from sandbox.projects.common import BaseGetMediaDatabaseTask
from sandbox.projects.common import utils


class GetVideoMiddlesearchDatabase(BaseGetMediaDatabaseTask.BaseGetMediaDatabaseTask):
    """
        Скачивает базу для видео среднего метапоиска по указанной
        или вычисленной по CMS rsync ссылке
    """

    type = "GET_VIDEO_MIDDLESEARCH_DATABASE"

    def _get_database_resource_type(self):
        return resource_types.VIDEO_MIDDLESEARCH_INDEX

    def _get_expected_files(self):
        return [
            "emergency.json",
            "shard.conf",
            "userdata/indexuserowndat",
            "userdata/indexuserowninv",
            "userdata/indexuserownkey",
            "userdata/query_factors_proto.trie",
            "userdata/userdata.conf",
            "videoplayers/connectors.xml",
            "videoplayers/generators.xml",
        ]

    def _get_filter_out_host_patterns(self):
        return ["lumiere", mset.MAN_REGION]

    def _get_cms_configurations(self):
        cms_configuration, _ = mset.VideoSettings.middlesearch_tag(mset.VideoSettings.MMETA_ID, mset.MAN_REGION, mset.VideoSettings.get_nanny_token(self))
        return [cms_configuration, 'BETA']

    def _get_default_shard_instance_tag(self):
        _, instance_tag_name = mset.VideoSettings.middlesearch_tag(mset.VideoSettings.MMETA_ID, mset.MAN_REGION, mset.VideoSettings.get_nanny_token(self))
        return instance_tag_name

    def _get_stable_middlesearch_database_resource(self):
        return utils.get_and_check_last_resource_with_attribute(resource_types.VIDEO_MMETA_SHARDMAP,
                                                                attr_name='released',
                                                                attr_value='stable')

    def _get_default_rsync_path(self):
        logging.info("Looking for default shard")

        stable_resource = self._get_stable_middlesearch_database_resource()
        # source format is VIDMMETA_vidmmeta-000-20161026-200027
        shardmap = stable_resource.attributes['shardmap_name']
        _, _, date, time = shardmap.split('.')[0].split('-')
        shard_name = 'vidmmeta-000-{date}-{time}'.format(date=date, time=time)
        shard_location = iss_shards.get_shard_name(shard_name)
        return shard_location


__Task__ = GetVideoMiddlesearchDatabase
