# -*- coding: utf-8 -*-

from sandbox.projects.common.BaseGetMediaDatabaseTask import BaseGetVideoDatabaseTask
from sandbox.projects import resource_types


class GetVideoQuickSearchDatabase(BaseGetVideoDatabaseTask):
    """
        Скачивает базу для видео базового поиска по указанной rsync ссылке
    """
    type = 'GET_VIDEO_QUICK_SEARCH_DATABASE'

    def _get_database_resource_type(self):
        return resource_types.VIDEO_QUICK_SEARCH_DATABASE

    def _get_expected_files(self):
        return BaseGetVideoDatabaseTask._get_expected_files(self) + ["indexuserurldat"]

    def _get_filter_out_host_patterns(self):
        return ['ams', 'man']

    def _get_default_shard_instance_tag(self):
        """
            Инстанс-тег, по которому искать дефолтный шард
        """
        return "production-vidfbase-msk"


__Task__ = GetVideoQuickSearchDatabase
