import tempfile
from os import chmod, remove

from sandbox.common.types.misc import DnsType
from sandbox import sdk2

from sandbox.sdk2.helpers.process import subprocess


class RunCommandInContainer(sdk2.Task):
    """
    Runs the specified command in a predefined LXC container.
    """

    class Requirements(sdk2.Task.Requirements):
        dns = DnsType.DNS64
        privileged = True

    class Parameters(sdk2.Task.Parameters):
        script = sdk2.parameters.String("Script to execute",
                                        required=True,
                                        multiline=True)
        container = sdk2.parameters.Container("Environment container resource",
                                              required=True)

    def on_execute(self):
        f = tempfile.NamedTemporaryFile(delete=False)

        # File must be closed before calling subprocess.call, so we have
        # to manage its lifetime ourselves and there's no point in using `with'
        try:
            f.write(self.Parameters.script)
            f.close()

            chmod(f.name, 0770)

            with sdk2.helpers.ProcessLog(self, logger="script") as log:
                subprocess.check_call(f.name,
                                      stdout=log.stdout,
                                      stderr=subprocess.STDOUT)
        finally:
            remove(f.name)
