import logging

from sandbox.projects.Haas.common import http as haas_http


class StepLogging(object):
    RUNNING = 'RUNNING'
    FAILED = 'FAILED'
    SUCCESS = 'SUCCESS'

    def __init__(self, api_url, auth_headers):
        self._API_URL = api_url
        self._AUTH_HEADERS = auth_headers

    def __call__(self, task_id, stage):
        return StepLogger(self.push_message_to_log, task_id, stage)

    def push_message_to_log(self, task_id, stage, state):
        url = '{}/tasks/{}/log'.format(self._API_URL, task_id)
        message = {'stage': stage, 'status': state}
        logging.info('Pushing message "{}" to log.'.format(message))
        haas_http.post(url, message, headers=self._AUTH_HEADERS)


class StepLogger(object):
    def __init__(self, log_method, task_id, stage):
        self.log_method = log_method
        self.task_id = task_id
        self.stage = stage

    def __enter__(self):
        self.log_method(self.task_id, self.stage, StepLogging.RUNNING)

    def __exit__(self, exc_type, exc_val, exc_tb):
        if exc_type is not None:
            logging.exception('Exception "{}", exc_val: "{}", catched during executing stage "{}".'
                              .format(exc_type, exc_val, self.stage)
                              )
            self.log_method(self.task_id, self.stage, StepLogging.FAILED)
            raise exc_type(exc_val)

        else:
            self.log_method(self.task_id, self.stage, StepLogging.SUCCESS)
