import logging

from sandbox.projects.Haas.common import http as haas_http


class SetupClient(object):
    def __init__(self, api_url, oauth_token):
        self._API_URL = api_url
        self._AUTH_HEADERS = {'Authorization': 'OAuth {}'.format(oauth_token)}

    def _setup_api_method(self, method, args=None, kwargs=None):
        logging.debug('Calling setup method "{}" with args: "{}" and kwargs: "{}"'.format(method, args, kwargs))
        data = {'method': method, 'args': args or [], 'kwargs': kwargs or {}}
        return haas_http.post(
            self._API_URL,
            data,
            headers=self._AUTH_HEADERS,
            json=True,
        )

    def deploy_host(self, inventory, config_name, host_name, host_macs):
        logging.info('Deploying host:\ninventory: "{}", config_name: "{}", host_name: "{}", host_macs: "{}"'.format(
            inventory,
            config_name,
            host_name,
            host_macs,
        ))
        return self._setup_api_method('setup', kwargs={
            'config': config_name,
            'inventory': inventory,
            'name': host_name,
            'mac': host_macs,
        })

    def get_deploy_status(self, inventory):
        logging.info('Getting deploy status for host "{}"'.format(inventory))
        server_info = self._setup_api_method('server_get', kwargs={'query': {'inventory': inventory}})
        deploy_status = server_info['result']['status']
        logging.info('Deploy status is: "{}"'.format(deploy_status))
        return deploy_status
