import time
import logging

from sandbox.sandboxsdk import errors


class TimeoutError(errors.SandboxTaskFailureError):
    pass


def check_until_not_true(update_period, timeout, predicate, *args):
    elapsed_time = 0

    while not predicate(*args) and elapsed_time < timeout:
        logging.debug('Sleeping "{}" seconds until next check iteration.'.format(update_period))
        time.sleep(update_period)
        elapsed_time += update_period

    if elapsed_time >= timeout:
        raise TimeoutError('Check is pending, timeout was "{}"'.format(timeout))
