import logging
import requests

from sandbox.projects.common import decorators
from sandbox.sandboxsdk import errors


@decorators.retries(max_tries=5, delay=5, raise_class=errors.SandboxTaskFailureError)
def post(url, data=None, headers=None, json=True):
    logging.debug('POST request to {}, data (json={}): {}, headers: {}'.format(url, json, data, headers))
    if json:
        response = requests.post(url, json=data, headers=headers, verify=False)
    else:
        response = requests.post(url, data=data, headers=headers, verify=False)
    response.raise_for_status()
    result = response.json()
    logging.debug('Response: {}'.format(result))
    return result


@decorators.retries(max_tries=5, delay=5, raise_class=errors.SandboxTaskFailureError)
def put(url, data=None, headers=None, json=True):
    logging.debug('PUT request to {}, data (json={}): {}, headers: {}'.format(url, json, data, headers))
    if json:
        response = requests.put(url, json=data, headers=headers, verify=False)
    else:
        response = requests.put(url, data=data, headers=headers, verify=False)
    response.raise_for_status()
    result = response.json()
    logging.debug('Response: {}'.format(result))
    return result


@decorators.retries(max_tries=5, delay=5, raise_class=errors.SandboxTaskFailureError)
def get(url, data=None, headers=None, json=True):
    logging.debug('GET request to {}, headers: {}'.format(url, headers))
    response = requests.get(url, headers=headers, verify=False)
    response.raise_for_status()
    result = response.json()
    logging.debug('Response: {}'.format(result))
    return result
